import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:permission_handler/permission_handler.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import '../../services/no_plan_inspection.dart';
import '../../view/CheckExecute/navigation_checkexec.dart';

///@Description     兼容海康手持机的新版二维码扫描页面
///@author          helinlin
///@create          2022-05-23 16:56

class NewQrPage extends StatefulWidget {
  final bool activeScan;

  const NewQrPage({Key key, this.activeScan}) : super(key: key);

  @override
  _NewQrPageState createState() => _NewQrPageState();
}

class _NewQrPageState extends State<NewQrPage> {
  MethodChannel methodChannel;
  String result = '';

  @override
  void initState() {
    super.initState();
    methodChannel = const MethodChannel('amosMethodChannel');
  }

  @override
  void didUpdateWidget(NewQrPage oldWidget) {
    super.didUpdateWidget(oldWidget);
    if (widget.activeScan && result.isEmpty) {
      checkPermission();
    }
  }

  /// 检查权限
  Future<void> checkPermission() async {
    bool hasPermission = await Permission.camera.isGranted;
    if (!hasPermission) {
      bool hasPermission = await Permission.camera.request().isGranted;
      if (!hasPermission) {
        MsgBox.showMessageOnly('请授予权限后重新操作！', context);
      } else {
        scan();
      }
    } else {
      scan();
    }
  }

  ///扫码
  Future<void> scan() async {
    result = await methodChannel.invokeMethod('scan');
    if (result != null && result.isNotEmpty) {
      getQueryPlanTaskBySerialInfo(1, result, null).then((data) {
        if (data == null) {
          MsgBox.showMessageOnly('接口返回数据为空！', context);
          return;
        }
        if (data.success) {
          Navigator.push(context, MaterialPageRoute(builder: (context) {
            return NavigationCheckExec(data.id, pointName: data.name, checkMode: 'QR');
          })).then((value) {});
        } else {
          MsgBox.showMessageOnly(data.message, context);
        }
      });
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.black54,
      appBar: AppBar(
        title: const Text(
          '二维码扫描',
          style: TextStyle(color: Colors.white, fontSize: 18),
        ),
        centerTitle: true,
        elevation: 0,
        brightness: Brightness.light,
        backgroundColor: Colors.black54,
      ),
      body: Container(
        color: Colors.black54,
        width: double.infinity,
        child: Container(
          padding: const EdgeInsets.only(top: 50),
          child: Column(
            children: <Widget>[
              Expanded(
                flex: 2,
                child: Column(
                  children: [
                    Container(
                      height: 40,
                      width: 200,
                      child: const Align(
                        alignment: Alignment.center,
                        child: Text(
                          '请扫描二维码',
                          style: TextStyle(fontSize: 16, color: Colors.white),
                        ),
                      ),
                      decoration: const BoxDecoration(
                        color: Colors.black38,
                        borderRadius: BorderRadius.all(Radius.circular(25.0)),
                      ),
                    ),
                  ],
                ),
              ),
              Expanded(
                child: Column(
                  children: [
                    ElevatedButton(
                      child: const Text('重新扫码'),
                      style: ButtonStyle(backgroundColor: MaterialStateProperty.all(Colors.blue)),
                      onPressed: () {
                        result = '';
                        if (widget.activeScan && result.isEmpty) {
                          checkPermission();
                        }
                      },
                    )
                  ],
                ),
              )
            ],
          ),
        ),
      ),
    );
  }
}
