import 'package:base/consts/color.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import '../../model/Task/TaskModel.dart';
import '../CheckExecute/ImageListView.dart';

class TaskFeecbackDetailPage extends StatefulWidget {
  FeedBack showfeedback;

  TaskFeecbackDetailPage({Key key, @required this.showfeedback}) : super(key: key);

  @override
  _TaskFeecbackDetailPage createState() => _TaskFeecbackDetailPage();
}

class _TaskFeecbackDetailPage extends State<TaskFeecbackDetailPage> {
  final TextEditingController _controller = TextEditingController();
  String theme = '';

  @override
  void initState() {
    super.initState();
  }

  Future<void> initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  List<Image> convertBase642File(List<String> picBase64List) {
    List<Image> result = [];
    picBase64List.forEach((s) {
      result.add(Image.network(s));
    });
    return result;
  }

  @override
  Widget build(BuildContext context) {
    if (widget.showfeedback == null) {
      return Scaffold(
        appBar: AppBar(
          title: const Text(
            '反馈详情',
          ),
          centerTitle: true,
          elevation: 0.2,
          brightness: Brightness.light,
        ),
      );
    }
    return Scaffold(
      appBar: AppBar(
        title: const Text(
          '反馈详情',
        ),
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
      ),
      body: ListView(children: <Widget>[
        Container(
          child: Column(
            children: <Widget>[
              TouchCallBack(
                  child: Column(
                    children: <Widget>[
                      Container(
                          color: Colors.white,
                          height: 50.0,
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: <Widget>[
                              Expanded(
                                child: Container(
                                  child: Row(
                                    children: const <Widget>[
                                      Text(
                                        '*',
                                        style: TextStyle(color: Colors.red),
                                      ),
                                      Text(
                                        '反馈信息',
                                        style:
                                            TextStyle(fontSize: 15.0, fontWeight: FontWeight.bold, color: Colors.black),
                                      ),
                                    ],
                                  ),
                                  padding: const EdgeInsets.only(left: 10.0),
                                ),
                                flex: 5,
                              ),
                            ],
                          )),
                      Container(
                        color: Colors.white,
                        margin: const EdgeInsets.all(20.0),
                        child: TextField(
                          enabled: false,
                          controller: _controller,
                          textAlign: TextAlign.start,
                          maxLines: 4,
                          decoration: InputDecoration(
                            border: InputBorder.none,
                            fillColor: Colors.grey[200],
                            filled: true,
                            hintText: null != widget.showfeedback ? widget.showfeedback.message : '',
                            contentPadding: const EdgeInsets.only(left: 20.0, right: 20.0, top: 40.0, bottom: 40.0),
                          ),
                        ),
                      ),
                    ],
                  ),
                  onPressed: () {}),
              const Padding(
                padding: EdgeInsets.only(left: 15.0, right: 15.0),
                child: Divider(
                  height: 0.5,
                  color: Color(0xffd9d9d9),
                ),
              ),
              const Padding(
                padding: EdgeInsets.only(top: 10.0, bottom: 10.0),
              ),
            ],
          ),
        ),
        Container(
            child: TouchCallBack(
                child: Container(
                    color: Colors.white,
                    height: 50.0,
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: <Widget>[
                        Expanded(
                          child: Container(
                            child: Row(
                              children: const <Widget>[
                                Text(
                                  '*',
                                  style: TextStyle(color: Colors.red),
                                ),
                                Text(
                                  '现场照片',
                                  style: TextStyle(fontSize: 15.0, fontWeight: FontWeight.bold, color: Colors.black),
                                ),
                              ],
                            ),
                            padding: const EdgeInsets.only(left: 10.0),
                          ),
                          flex: 5,
                        ),
                        Expanded(
                          child: Row(
                            children: <Widget>[
                              Icon(
                                Icons.camera_alt,
                                color: GetConfig.getColor(theme),
                                size: 16,
                              ),
                              Icon(
                                Icons.chevron_right,
                                color: GetConfig.getColor(theme),
                              ),
                            ],
                          ),
                          flex: 1,
                        ),
                      ],
                    )),
                onPressed: () {
                  Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) => ImageListView(convertBase642File(
                              null != widget.showfeedback ? widget.showfeedback.feedbackPics : []))));
                })),
      ]),
    );
  }
}
