# jcs_airport

机场智慧消防 APP

## 后端菜单配置说明

所属应用均填 `具体的目标应用` 即可，终端类型均为 `APP`，菜单类型均为 `菜单`

```
    菜单名称                  组件                 路径/授权标识
.
├── 智慧消防app
├── 首页                     Home	                home   
├── └── 实时监测	                                 /
│       ├── 火警	          fireAlarm	            /alarmInfo
│       ├── 故障	          fault	                /alarmInfo
│       ├── 屏蔽	          shield	            /alarmInfo
│       ├── 预警	          warning	            /alarmInfo
│       ├── 未处理	          no	                /alarmInfo
│       └── 已处理		      yes	                /alarmInfo
├── └── 作战指挥	                                 /
│       ├── 当前警情	      dispatchAlarm	        /dispatchAlarm
│       └── 当前任务		  dispatchTask	        /dispatchTask
├── 工作台                   WorkBench	            workBench
│   └── 日常巡检                                  /
│       ├── 计划巡检                             /PlanPatrol
│       ├── 无计划巡检	                        /NoPlanPatrol
│       ├── 移动巡检	                            /MoblePatrol
│       ├── 巡检记录	                            /PatrolLog
│       ├── 巡检点                               /PatrolPoint
│       └── 巡检日历	                            /PatrolCalendar
│   └── 隐患治理                                  /
│       ├── 待处理                               /waitHandle
│       ├── 已处理	                            /haveHandle
│       ├── 隐患添加	                            /latentDangerSave
│       ├── 隐患复查	                            /hiddenDangerReview
│       └── 隐患审核	                            /hiddenDangerAudit
│   └── 缺陷治理                                  /
│       ├── 我接收                               /MyReceive
│       ├── 我发起	                            /MySend
│       ├── 任务添加	                            /AddTask
│       └── 全部任务	                            /AllTask
│   └── 消防维保                                  /
│       ├── 维保任务                             /maintenanceTask
│       ├── 维保设施	                            /maintenanceEquipment
│       ├── 维保记录	                            /maintenanceRecord
│       └── 维保日历	                            /maintenanceCalender
│   └── 防火监督	                                /
│       └── 计划检查		                        /fireproofPlanCheck
│   └── 故障报修	                                /
│       ├── 故障报修	                            /malfunctionReport
│       ├── 报修清单		                        /reportTaskAll
│       ├── 我发起	                            /reportTaskInitiate
│       └── 待处理		                        /reportTaskWaiting
│   └── 实时监测	                                /
│       ├── 告警信息	      alarmInfo	            /alarmInfo
│       └── 物联设施		  iotFacilities	        /iotFacilities
│       └── 在岗监测		  monitorEvent	        /monitorEvent
│   └── 作战指挥	                                /
│       ├── 作战地图	      dispatchMap	        /dispatchMap
│       ├── 危化品	      hazardousChemicals	/hazardousChemicals
│       ├── 车辆绑定	      bindingCar	        /bindingCar
│       └── 联动信息		  linkageInformation	/linkageInformation
│   └── 计算公式	                                /
│       ├── 泡沫原液量	  foamFluid   	        /foamFluid
│       ├── 立罐灭火用水量   verticalTankWater    /verticalTankWater
│       ├── 液化烃球罐用水量 hydrocarbonTank     	/hydrocarbonTank
│       └── 管网供水能力	  pipeWater 	        /pipeWater
├── 消息                      Message	            message
├── 我的                      Mine	                mine
├   └...
└── ...
```

> 注意，巡检功能，是通用模块，只需要在工作台中新增 `日常巡检` 模块即可。

日常巡检模块：

```
    菜单名称                  组件                 路径/授权标识

.
├── 智慧消防app 
├── 工作台                   WorkBench	            workBench
│   └── 日常巡检              PatrolApp	             /AppPatrol
│       ├── 计划巡检                                 /PlanPatrol
│       ├── 无计划巡	                             /NoPlanPatrol
│       ├── 移动巡检		                         /MoblePatrol
│       ├── 巡检记录		                         /PatrolLog
│       ├── 巡检点		                             /PatrolPoint
│       └── 巡检日历	                             /PatrolCalendar
├   └...
└── ...
```

## prod

直接在 `AndroidStudio` 中进行打包，或者输入如下指令进行打包

```bash
# 进入 jcs_airport
cd appstore/jcs_airport
# build
flutter build apk --no-tree-shake-icons
```

> 注意，如果用 as 打包时，debug 包无法运行，此时需要在 terminal 中执行 `flutter build apk --debug` 即可。
