import 'dart:io';

import 'package:base/services/api_address.dart';
import 'package:dio/dio.dart';
import 'package:jcs_airport/consts/file_type.dart';
import 'package:jcs_airport/consts/url_const.dart';
import 'package:jcs_airport/utils/request.dart';
import 'package:jcs_airport/view/common/image_picker.dart';
import 'package:jcs_airport/viewmodel/confirm_alam.dart';
import 'package:jcs_airport/viewmodel/monitor_event.dart';

class API {

  ///------------------------------------------------AMOS平台---------------------------------------------------

  /// 根据计量编号获取设备详情
  static Future queryEquipDetailsByCode(String code) async {
    return await AmosHttp.client.get(URLConst.queryEquipDetailsByCode, query: { "equipmentCode": code });
  }

  /// 根据计量编号进行送检、接收、报废
  static Future scanEquipQrCodeBizCode(String code, String type) async {
    return await AmosHttp.client.get(URLConst.scanEquipQrCodeBiz, query: { "equipmentCode": code, 'type': type });
  }
}
