import 'package:amos_flutter_utils/date_utils.dart';

class ConvertDate {
  static DateRange convertDateTextToRealValue(String text) {
    DateRange date;
    DateTime now = DateTime.now();
    switch (text) {
      case '今天':
        String dateTime = DateUtils.formatDate(now, format: 'yyyy-MM-dd');
        date = DateRange('$dateTime 00:00:00', '$dateTime 23:59:59');
        break;
      case '昨天':
        String dateTime = DateUtils.formatDate(now.add(const Duration(days: -1)), format: 'yyyy-MM-dd');
        date = DateRange('$dateTime 00:00:00', '$dateTime 23:59:59');
        break;
      case '本周':
        String dateTime = DateUtils.formatDate(now.add(Duration(days: -(now.weekday - 1))), format: 'yyyy-MM-dd');
        date = DateRange('$dateTime 00:00:00', '${DateUtils.formatDate(now, format: 'yyyy-MM-dd')} 23:59:59');
        break;
      case '上周':
        DateTime previousWeekFirstDay = now.add(Duration(days: -(now.weekday - 1) - 7));
        DateTime previousWeekLastDay = now.add(Duration(days: -(now.weekday - 1) - 1));
        date = DateRange('${DateUtils.formatDate(previousWeekFirstDay, format: 'yyyy-MM-dd')} 00:00:00',
            '${DateUtils.formatDate(previousWeekLastDay, format: 'yyyy-MM-dd')} 23:59:59');
        break;
      case '本月':
        DateTime currentMonthFirstDay = DateTime(now.year, now.month);
        date = DateRange('${DateUtils.formatDate(currentMonthFirstDay, format: 'yyyy-MM-dd')} 00:00:00',
            '${DateUtils.formatDate(now, format: 'yyyy-MM-dd')} 23:59:59');
        break;
      case '上月':
        DateTime previousMonthFirstDay = DateTime(now.year, now.month - 1);
        DateTime previousMonthLastDay = DateTime(now.year, now.month, 0);
        date = DateRange('${DateUtils.formatDate(previousMonthFirstDay, format: 'yyyy-MM-dd')} 00:00:00',
            '${DateUtils.formatDate(previousMonthLastDay, format: 'yyyy-MM-dd')} 23:59:59');
        break;
      default:
        date = const DateRange('', '');
    }
    return date;
  }
}

class DateRange {
  final String startTime;
  final String endTime;

  const DateRange(this.startTime, this.endTime);
}
