import 'package:chewie/chewie.dart';
import 'package:flutter/material.dart';
import 'package:flutter_swiper/flutter_swiper.dart';

import 'image_picker.dart';

///图片预览
class ImageSwiperPage extends StatefulWidget {
  final List<ChooseFileInfo> files;
  final int index;

  @override
  State<StatefulWidget> createState() => _ImageSwiperPageState();

  const ImageSwiperPage(this.files, {this.index = 0});
}

class _ImageSwiperPageState extends State<ImageSwiperPage> {
  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        body: Container(
      color: Colors.black,
      child: Center(
        child: Swiper(
          autoplay: false,
          index: widget.index,
          loop: false,
          itemBuilder: (BuildContext context, int index) {
            ChooseFileInfo chooseFileInfo = widget.files[index];
            return chooseFileInfo.isPhoto
                ? widget.files[index].file != null
                    ? Image.file(widget.files[index].file)
                    : Image.network(widget.files[index].url)
                : Chewie(
                    controller: chooseFileInfo.chewieController,
                  );
          },
          itemCount: widget.files.length,
          pagination: const SwiperPagination(),
          control: const SwiperControl(size: 25),
        ),
      ),
    ));
  }

  @override
  void dispose() {
    super.dispose();
    widget.files.forEach((element) {
      if (element.isVideo) {
        element.chewieController.pause();
      }
    });
  }
}
