import 'package:flutter/material.dart';
import 'package:timelines/timelines.dart';

import 'TimeLineData.dart';

///时间轴靠左文字居右
class TimeLineLeft extends StatelessWidget {
  List<TimeLineData> data;
  Image image;

  TimeLineLeft(this.data, {this.image});

  @override
  Widget build(BuildContext context) {
    return Timeline.tileBuilder(
      padding: const EdgeInsets.all(15),
      shrinkWrap: true,
      //主题配置
      theme: TimelineThemeData(
        nodePosition: 0,
        connectorTheme: const ConnectorThemeData(),
        indicatorTheme: const IndicatorThemeData(),
      ),
      builder: TimelineTileBuilder.connected(
        contentsAlign: ContentsAlign.basic,
        //右边内容
        contentsBuilder: (context, index) => Padding(
          padding: const EdgeInsets.all(10.0),
          child: Container(
            width: double.infinity,
            child: Column(
                mainAxisAlignment: MainAxisAlignment.end,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Padding(
                    padding: const EdgeInsets.only(left: 5.0),
                    child: Text(
                      data[index].rightText,
                    ),
                  ),
                  Transform.translate(
                    offset: const Offset(0, 3),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.end,
                      children: [
                        Text(
                          data[index].leftText,
                          style: const TextStyle(color: Colors.black45),
                        )
                      ],
                    ),
                  )
                ]),
          ),
        ),
        //连接线
        connectorBuilder: (context, index, type) => SizedBox(
          height: data[index].height,
          child: const SolidLineConnector(
            color: Colors.grey,
            thickness: 1,
          ),
        ),
        //连接点
        indicatorBuilder: (context, index) => Stack(
          children: [
            image,
            data[index].isFinished
                ? Positioned(
                    top: 0,
                    right: 0,
                    child: Transform.translate(
                      offset: const Offset(10, -2),
                      child: const Icon(
                        Icons.check,
                        color: Colors.green,
                        size: 16,
                      ),
                    ))
                : Container()
          ],
        ),
        itemCount: data.length,
      ),
    );
  }
}
