/// 计算公式 - 通用页面和结果页面
///
///

import 'package:flutter/material.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

/// 通用计算 form page
class CommonFormulaPage extends StatelessWidget {
  const CommonFormulaPage({Key key, this.title, this.formChild, this.onSubmit, this.onReset}) : super(key: key);

  final String title;
  final Widget formChild;
  final Function onSubmit;
  final Function onReset;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(title ?? ''),
      ),
      body: CommonFormulaContent(
        formChild: formChild,
        onSubmit: onSubmit,
        onReset: onReset,
      ),
    );
  }
}

/// 通用计算 form page
class FormulaButtonSubmit extends StatelessWidget {
  const FormulaButtonSubmit({Key key, this.title, this.body, this.formChild, this.onSubmit, this.onReset})
      : super(key: key);

  final String title;
  final Widget formChild;

  /// 自定义 body，如果不为 null，则采用自定义的 body，此时 formChild 不起效
  final Widget body;
  final Function onSubmit;
  final Function onReset;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(title ?? ''),
      ),
      body: body ??
          CommonFormulaContent(
            formChild: formChild,
            hasFooter: false,
          ),

      /// 将计算按钮放置在最底部
      persistentFooterButtons: [
        Row(
          children: [
            Button(
                width: (MediaQuery.of(context).size.width / 2) - 20,
                background: Theme.of(context).primaryColor,
                child: const Text('计算'),
                onPressed: () {
                  onSubmit(context);
                }),
            const SizedBox(
              width: 20,
            ),
            Button(
              width: (MediaQuery.of(context).size.width / 2) - 20,
              background: const Color(0xffe3e3e3),
              child: const Text(
                '重置',
                style: TextStyle(color: Color(0xff333333)),
              ),
              onPressed: onReset,
            ),
          ],
        ),
      ],
    );
  }
}

class CommonFormulaContent extends StatelessWidget {
  const CommonFormulaContent({Key key, this.formChild, this.onSubmit, this.onReset, this.hasFooter = true})
      : super(key: key);

  final Widget formChild;
  final Function onSubmit;
  final Function onReset;

  /// 是否内置 footer，如果为 true，则需要传入 onSubmit 与 onReset
  final bool hasFooter;

  @override
  Widget build(BuildContext context) {
    return SingleChildScrollView(
      child: Column(children: [
        formChild,
        hasFooter
            ? FormFooter(
                padding: const EdgeInsets.symmetric(vertical: 6, horizontal: 15.0),
                child: Flex(direction: Axis.horizontal, children: [
                  Expanded(
                    flex: 1,
                    child: GradientButton(
                        color: const Color(0xff345fa6),
                        child: const Text('计算'),
                        onPressed: () {
                          onSubmit(context);
                        }),
                  ),
                  Expanded(
                    flex: 1,
                    child: GradientButton(
                      color: const Color(0xffe3e3e3),
                      textColor: const Color(0xff333333),
                      child: const Text('重置'),
                      onPressed: onReset,
                    ),
                  )
                ]),
              )
            : Container(),
      ]),
    );
  }
}

/// 通用计算结果面板
class CommonResultPanel extends StatelessWidget {
  const CommonResultPanel({Key key, this.resultChild}) : super(key: key);

  final Widget resultChild;

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 360.0,
      child: Column(
        children: [
          Padding(
            padding: const EdgeInsets.symmetric(vertical: 16.0),
            child: Center(
              child: Column(
                children: [
                  Image.asset(
                    'assets/dispatch/calc.png',
                    width: 45.0,
                  ),
                  const Text('计算结果')
                ],
              ),
            ),
          ),
          Expanded(
            child: Padding(
              padding: const EdgeInsets.symmetric(vertical: 16.0, horizontal: 6.0),
              child: resultChild,
            ),
          ),
          Row(children: [
            ExpandedButton(
                height: 50.0,
                child: const Text(
                  '重新计算',
                  style: TextStyle(color: Colors.white),
                ),
                color: const Color(0xff345fa6),
                onPressed: () {
                  Navigator.of(context).pop();
                })
          ])
        ],
      ),
    );
  }
}

/// 计算结果页面
class CalcResultPanel extends StatelessWidget {
  const CalcResultPanel({Key key, this.results}) : super(key: key);

  final List<Map<String, dynamic>> results;

  @override
  Widget build(BuildContext context) {
    return CommonResultPanel(
      resultChild: ListView.separated(
        separatorBuilder: (context, index) {
          return const Divider(
            height: 0,
          );
        },
        itemBuilder: (context, index) {
          Widget title;
          Map item = results[index];
          title = LabelValue(
            label: item['title'],
            value: '${item['value']}',
            labelStyle: const TextStyle(fontSize: 16.0),
            valueStyle: const TextStyle(fontSize: 16.0, fontWeight: FontWeight.bold),
          );
          return ListTile(
            title: title,
          );
        },
        itemCount: results.length ?? 0,
      ),
    );
  }
}
