import 'package:amos_flutter_ui/card/common_card.dart';
import 'package:amos_flutter_ui/common/index.dart';
import 'package:flutter/material.dart';
import 'package:full_screen_image/full_screen_image.dart';
import 'package:jcs_airport/services/api.dart';
import 'package:amos_iot_login_tpl/const/global_config.dart';

///@Description     重点部位
///@author          helinlin
///@create          2022-01-17 17:05
class ImportantPoint extends StatefulWidget {
  final String sequenceNbr;

  const ImportantPoint({Key key, this.sequenceNbr}) : super(key: key);

  @override
  _ImportantPointState createState() => _ImportantPointState();
}

class _ImportantPointState extends State<ImportantPoint> {
  Map keySiteInfo = {
    'attachmentsList': [] //照片
  }; //重点部位信息
  //List<String> images = ['assets/11.jpg', 'assets/11.jpg', 'assets/11.jpg'];
  String imageUrl = '';
  @override
  void initState() {
    super.initState();
    _getkeySite(widget.sequenceNbr);
    
    APIUrlManager.getImageUrl().then((value) {
        setState(() {
          imageUrl = value;
        });
      });


  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('重点部位'),
      ),
      body: SingleChildScrollView(
        child: Column(
          children: [
            CommonCard(
              child: Padding(
                padding: const EdgeInsets.all(8.0),
                child: Column(children: [
                  buildRow('重点部位名称', keySiteInfo['name']),
                  buildRow('所属部门', keySiteInfo['belongName']),
                  buildRow('所在建筑', keySiteInfo['buildingName']),
                  buildRow('位置描述', keySiteInfo['addressDesc']),
                  buildRow('建筑面积(㎡)', keySiteInfo['buildingArea']),
                  buildRow('耐火等级', keySiteInfo['fireEnduranceRateName']),
                  buildRow('使用性质', keySiteInfo['useNatureName']),
                  buildRow('责任人', keySiteInfo['chargePerson']),
                  buildRow('确定重点防火部位原因', keySiteInfo['keyPreventionReason']),
                  buildRow('消防设施情况', (keySiteInfo['firePreventionFlag'] ?? false) ? '已设立' : '未设立'),
                  buildRow('危险源', keySiteInfo['hazard']),
                  buildRow('消防安全管理措施', keySiteInfo['safetyManagementMeasures']),
                  buildRow('防范手段和措施', keySiteInfo['preventiveMeasures']),
                  const SizedBox(
                    height: 5,
                  ),


                  // SingleChildScrollView(
                  //   child:
                  //   Row(
                  //     children: (keySiteInfo['attachmentsList'] ?? [])
                  //         .map((image) => Padding(
                  //               padding: const EdgeInsets.all(8.0),
                  //               child: 
                  //                FullScreenWidget(
                  //                 disposeLevel: DisposeLevel.Low,
                  //                 child: Image.asset(
                  //                   image,
                  //                   width: 100,
                  //                 ),
                  //               ),
                  //             ))
                  //         .cast<Widget>()
                  //         .toList(),
                  //   ),
                  // )


                  
                      Padding(
                        padding: const EdgeInsets.all(4.0),
                        child: Column(
                          children: [
                            const Text('重点部位照片'),
                            const SizedBox(
                              height: 5,
                            ),
                            keySiteInfo['attachmentsList'].isEmpty
                                ? const Opacity(
                                    opacity: 0.6,
                                    child: Text(
                                      '暂无',
                                      style: TextStyle(fontSize: 12),
                                    ),
                                  )
                                :     buildGridimg(keySiteInfo['attachmentsList'])                                                                      
                          ],
                        ),
                      ),
                    


                ]),
              ),
            )
          ],
        ),
      ),
    );
  }



//  Widget buildGrid(List formList) {
//         List<Widget> tiles = [];//先建一个数组用于存放循环生成的widget
//         Widget content; //单独一个widget组件，用于返回需要生成的内容widget
//         for(var item in formList) {
//             tiles.add(
//              FullScreenWidget(
//                     disposeLevel: DisposeLevel.Low,
//                     child:
//                     Image.network(
//                       imageUrl + item,
//                       width: 100,
//                     ),
//                   )
//             );
//         }
//         content = Row(
//             mainAxisAlignment: MainAxisAlignment.start,
//             children:           
//               tiles//重点在这里，因为用编辑器写Column生成的children后面会跟一个<Widget>[]，            
//             );
//         return tiles;
//     }


Widget buildGridimg(List formList) {

    List<Widget> tiles = [];//先建一个数组用于存放循环生成的widget
        for(var item in formList) {
            tiles.add(
             FullScreenWidget(
                    disposeLevel: DisposeLevel.Low,
                    child:
                    Image.network(
                      imageUrl + item,
                      width: 100,
                    ),
                  )
            );
        }


    return Wrap(
      spacing: 2, //主轴上子控件的间距
      runSpacing: 5, //交叉轴上子控件之间的间距
      children: tiles, //要显示的子控件集合
    );
  }





  Widget buildRow(String title, String content) {
    return Padding(
      padding: const EdgeInsets.only(bottom: 5.0),
      child: Row(
        children: [
          Expanded(child: Text(title + ':')),
          Expanded(child: Text(content ?? '')),
        ],
      ),
    );
  }

  ///获取重点部位
  void _getkeySite(String sequenceNbr) {
    API.getkeySite(sequenceNbr).then((value) {
      if (value != null) {
        setState(() {
          keySiteInfo.addAll(value);
        });
      }
    });
  }
}
