import 'package:flutter/material.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import './../entity/alarm_disaster.dart';
import './../entity/assembley_point.dart';
import './../event_bus.dart';
import './../native_bridge.dart';
import './assembly_point.dart';
import './realtime_distance.dart';

/// 集结点编辑
class EditAssembleyPoint extends StatefulWidget {
  const EditAssembleyPoint(
      {Key key,
      this.callJSMethod,
      this.assembleyPoint,
      this.token,
      this.h5Url,
      this.controller,
      this.currentLngLat,
      this.alarmDisaster})
      : super(key: key);

  final ExecuteJSMethod callJSMethod;

  final AlarmDisaster alarmDisaster;

  final String h5Url;

  final AssembleyPoint assembleyPoint;

  final ScrollController controller;

  final String token;

  final Map currentLngLat;

  @override
  _EditAssembleyPointState createState() => _EditAssembleyPointState();
}

class _EditAssembleyPointState extends State<EditAssembleyPoint> {
  @override
  Widget build(BuildContext context) {
    return ListView(
        controller: widget.controller,
        padding: const EdgeInsets.fromLTRB(10, 0, 10, 0),
        children: <Widget>[buildBasicInfo(context)]);
  }

  /// 基本信息
  Widget buildBasicInfo(BuildContext context) {
    AlarmDisaster alarm = widget.alarmDisaster ?? AlarmDisaster();
    AssembleyPoint assembleyPoint = widget.assembleyPoint ?? AssembleyPoint();
    Function callback = widget.callJSMethod;
    return Container(
        child: Column(children: [
      Container(
          child: Row(children: [
        RealtimeDistance(
            callJSMethod: widget.callJSMethod,
            targetLanLat: {
              'latitude': assembleyPoint.latitude,
              'longitude': assembleyPoint.longitude
            },
            currentLngLat: widget.currentLngLat,
            distance: alarm.distance,
            msgType: EventDataType.Self2AlarmDistance,
            style: const TextStyle(
                color: Color(0xff333333),
                fontWeight: FontWeight.bold,
                fontSize: 18))
      ])),
      Container(child: Row(children: [Text('车辆集结区')])),
      Container(
        height: 25.0,
        child: Row(children: [
          const Expanded(child: SizedBox(width: 100)),
          OutlineButton(
              shape: const RoundedRectangleBorder(
                  side: BorderSide.none,
                  borderRadius: BorderRadius.all(Radius.circular(50))),
              textColor: CoreColors.textColor,
              padding: EdgeInsets.zero,
              child: const Text(
                '修改',
                style: TextStyle(fontSize: 12),
              ),
              onPressed: () {
                Navigator.push(context, MaterialPageRoute(builder: (context) {
                  return AssemblyPointSet(
                      callh5: callback,
                      alarmId: alarm.sequenceNbr,
                      h5Url: widget.h5Url,
                      assemblyPointId: assembleyPoint.sequenceNbr,
                      token: widget.token);
                })).then((value) {
                  if (value != null) {
                    /// 保存完集结点之后，执行刷新操作
                    /// 采用 callback 执行主地图消息
                    // callback('refreshAssemblyPoint()');
                    callback('$value()');
                  }
                });
              }),
          const Text('  '),
          OutlineButton(
              shape: const RoundedRectangleBorder(
                  side: BorderSide.none,
                  borderRadius: BorderRadius.all(Radius.circular(50))),
              textColor: CoreColors.textColor,
              padding: EdgeInsets.zero,
              child: const Text(
                '导航',
                style: TextStyle(fontSize: 12),
              ),
              onPressed: () {
                /// 直接唤起高德、百度 app
                showBottomSheetList(
                    context: context,
                    items: ['腾讯地图', '百度地图', '高德地图'],
                    onItemTap: (int index, String item) {
                      if (widget.assembleyPoint.longitude == null ||
                          widget.assembleyPoint.latitude == null) {
                        return null;
                      }
                      switch (index) {
                        case 0:
                          List<num> latlng = GISUtil.gps84_To_Gcj02(double.parse(assembleyPoint.latitude),
                              double.parse(assembleyPoint.longitude));
                          CallMapUtil.callTencentMap(latlng[1], latlng[0]);
                          break;
                        case 1:
                          List<num> latlng = GISUtil.gps84_To_bd09(double.parse(assembleyPoint.latitude),
                              double.parse(assembleyPoint.longitude));
                          CallMapUtil.callBaiduMap(latlng[1], latlng[0]);
                          break;
                        case 2:
                          List<num> latlng = GISUtil.gps84_To_Gcj02(double.parse(assembleyPoint.latitude),
                              double.parse(assembleyPoint.longitude));
                          CallMapUtil.callAMap(latlng[1], latlng[0]);
                          break;
                        default:
                      }
                    });
              })
        ]),
      )
    ]));
  }
}
