import 'package:flutter/material.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import '../../../services/api.dart';

/// 车辆状态
class CarInfo extends StatefulWidget {
  const CarInfo(this.alarmId, this.carInfo);
  final String alarmId;
  final dynamic carInfo;

  @override
  _CarInfoState createState() => _CarInfoState();
}

class _CarInfoState extends State<CarInfo> {
  List staskSquadrons = [];

  String selectKey = '';

  dynamic usrInfo;

  List<Map<String, String>> _resourceMaps = [];

  @override
  void initState() {
    super.initState();
    getCarStatusList();
  }

  @override
  Widget build(BuildContext context) {
    return Positioned(
      top: 10,
      right: 5.0,
      child: Container(
          height: 30,
          decoration: const BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.all(Radius.circular(8.0))),
          child: Stack(alignment: AlignmentDirectional.center, children: [
            Wrap(spacing: 0,

                /// 子Widget列表
                children: [renderSquadron(context)])
          ])),
    );
  }

  Widget renderSquadron(BuildContext context) {
    return Container(
        width: 70,
        alignment: Alignment.center,
        child: InkWell(
          child: Row(mainAxisAlignment: MainAxisAlignment.center, children: [
            Column(mainAxisAlignment: MainAxisAlignment.center, children: [
              Container(
                  child: Row(children: [
                Image.asset('assets/map_power.png', width: 20, height: 20),
                const SizedBox(width: 8),
                Text(widget.carInfo['carStatus']),
              ]))
            ])
          ]),
          onTap: () {
            openSourceTypeSheet(context);
          },
        ));
  }

  void openSourceTypeSheet(BuildContext context) {
    TopSheetDialog.show(
        context: context,
        child: StatefulBuilder(builder: (BuildContext context, StateSetter ss) {
          return SelectCarStatusTypePanel(
            onChanged: (selectKeys) {
              selectKey = selectKeys;
            },
            selectKeys: selectKey,
            resourceMaps: _resourceMaps,
            reset: () {
              setState(() {
                selectKey = '';
                ss(() {});
              });
            },
            ok: () {
              /// 掉持久化方法，改变车辆状态
              if (selectKey != '') {
                doSaveCarStatus(selectKey);
              }
            },
          );
        }),
        backgroundColor: Colors.transparent,
        direction: TopSheetDialogDirection.TOP);
  }

  dynamic doSaveCarStatus(selectKey) {
    API.updateCarStatus('', selectKey).then((resp) => {});
  }

  dynamic getCarStatusList() {
    API.getCarStatusList().then((resp) => {
          setState(() {
            _resourceMaps = resp;
          })
        });
  }
}

/// 选择资源类型, 包含 底部按钮
class SelectCarStatusTypePanel extends StatelessWidget {
  const SelectCarStatusTypePanel(
      {Key key,
      this.selectKeys,
      this.onChanged,
      this.resourceMaps,
      this.reset,
      this.ok})
      : super(key: key);

  final String selectKeys;
  final void Function(String selectKeys) onChanged;
  final Function reset;
  final Function ok;
  final List resourceMaps;

  @override
  Widget build(BuildContext context) {
    return Container(
        height: 256.0,
        child: Column(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              TagSelectPanel(
                  crossAxisCount: 3,
                  datas: resourceMaps,
                  selectKey: selectKeys,
                  onChanged: onChanged),
              Row(mainAxisAlignment: MainAxisAlignment.spaceBetween, children: [
                ExpandedButton(
                  height: 48.0,
                  child: const Text('重置'),
                  onPressed: reset,
                ),
                ExpandedButton(
                  height: 48.0,
                  color: const Color(0xff345fa6),
                  child: const Text(
                    '确定',
                    style: TextStyle(color: Colors.white),
                  ),
                  onPressed: () {
                    Navigator.of(context).pop();
                    ok();
                  },
                ),
              ])
            ]));
  }
}
