import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:jcs_airport/routes/routes.dart';
import 'package:jcs_airport/services/api.dart';

/// 力量调度
class PowerInfo extends StatefulWidget {
  const PowerInfo(this.alarmId, this.latitude, this.longitude, {Key key}) : super(key: key);
  final String alarmId;
  final String latitude;
  final String longitude;

  @override
  _PowerState createState() => _PowerState();
}

class _PowerState extends State<PowerInfo> {
  List staskSquadrons = [];

  @override
  void initState() {
    super.initState();
    getSquadronList();
  }

  @override
  Widget build(BuildContext context) {
    return staskSquadrons.isNotEmpty
        ? Container(
            decoration: const BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.all(
                Radius.circular(8.0),
              ),
              boxShadow: <BoxShadow>[
                BoxShadow(offset: Offset(0, 1), color: Color.fromRGBO(0, 0, 0, 0.2), blurRadius: 3.0, spreadRadius: 1.0)
              ],
            ),
            margin: const EdgeInsets.only(left: 10, top: 10, right: 10),
            padding: const EdgeInsets.symmetric(horizontal: 6, vertical: 6),
            child: Stack(alignment: AlignmentDirectional.center, children: [
              Wrap(
                  spacing: 0,

                  /// 子Widget列表
                  children: renderSquadron())
            ]))
        : Container();
  }

  List<Widget> renderSquadron() {
    List<Widget> list = [];
    staskSquadrons.forEach((element) {
      list.add(Container(
          width: 100,
          alignment: Alignment.center,
          decoration: const BoxDecoration(
            borderRadius: BorderRadius.all(Radius.circular(5)),
          ),
          child: InkWell(
            child: Row(mainAxisAlignment: MainAxisAlignment.center, children: [
              Image.asset('assets/map_power.png', width: 30, height: 30),
              const SizedBox(width: 5),
              Column(mainAxisAlignment: MainAxisAlignment.center, children: [
                Container(
                    child: Row(
                        children: [const Text('车辆:'), const SizedBox(width: 8), Text(element['carNum'].toString())])),
                Container(
                    child: Row(
                        children: [const Text('人员:'), const SizedBox(width: 8), Text(element['userNum'].toString())]))
              ])
            ]),
            onTap: () {
              Get.toNamed(JCSRoutes.powerDispatching, arguments: widget.alarmId);
            },
          )));
    });
    return list;
  }

  void getSquadronList() {
    if (widget.alarmId == null) {
      return;
    }
    API.taskSquadronList(widget.alarmId).then((linkageForce) {
      if (linkageForce != null) {
        setState(() {
          staskSquadrons = linkageForce;
        });
      }
    });
  }
}
