import 'package:flutter/material.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:get/get.dart';

/// 危化品详情
class HazardousChemicalsDetail extends StatefulWidget {
  const HazardousChemicalsDetail({Key key}) : super(key: key);

  @override
  _HazardousChemicalsDetailState createState() =>
      _HazardousChemicalsDetailState();
}

class _HazardousChemicalsDetailState extends State<HazardousChemicalsDetail> {
  int pageIndex = 1;
  bool hasNext = false;
  // 分页所需控件
  bool isAnimating = false;
  String theme = '';
  dynamic hazardousChemicalsModel = {};
  List hazardousList = [
    {'key': 'name', 'name': '名        称', 'title': ''},
    {'key': 'englishName', 'name': '英  文  名', 'title': ''},
    {'key': 'ingredient', 'name': '主要成分', 'title': ''},
    {'key': 'formula', 'name': '分  子  式', 'title': ''},
    {'key': 'type', 'name': '类        型', 'title': ''},
    {'key': 'un', 'name': '国  标  号', 'title': ''},
    {'key': 'tabu', 'name': '禁  忌  物', 'title': ''},
    {'key': 'store', 'name': '贮藏方法', 'title': ''},
    {'key': 'property', 'name': '性       状', 'title': ''},
    {'key': 'leakWay', 'name': '泄漏处理', 'title': ''},
    {'key': 'dispose', 'name': '处理措施', 'title': ''},
    {'key': 'defendWay', 'name': '防护处理', 'title': ''},
    {'key': 'symptom', 'name': '症        状', 'title': ''},
  ];

  @override
  void initState() {
    super.initState();
    hazardousChemicalsModel = Get.arguments;
    hazardousList.forEach((element) {
      String key = element['key'];
      element['title'] = hazardousChemicalsModel[key];
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text('危化品详情',
            style: Theme.of(context).appBarTheme.textTheme.headline1),
      ),
      body: Stack(
        children: <Widget>[
          Container(
              decoration: const BoxDecoration(color: Color(0xffefefef)),
              margin: const EdgeInsets.only(top: 10),
              child: Column(children: <Widget>[
                Expanded(
                child: Stack(children: <Widget>[
              SingleChildScrollView(
                  child: ListView.builder(
                      physics: const NeverScrollableScrollPhysics(),
                      key: const PageStorageKey('data'),
                      itemCount: hazardousList.length,
                      shrinkWrap: true,
                      itemBuilder: (BuildContext context, int index) =>
                          ListInfoView(index, hazardousList[index])))
                ]))
              ])),
        ],
      ),
    );
  }
}

class ListInfoView extends StatelessWidget {
  int row;
  dynamic bean;

  ListInfoView(this.row, this.bean, {Key key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      alignment: Alignment.center,
      //单双行con颜色
      color: row % 2 == 0 ? Colors.white : const Color(0xffefeff4),
      child: getTextView(),
    );
  }
  //返回文字view
  Widget getTextView() {
    return Container(
        padding: const EdgeInsets.all(10),
        child: LabelValue(label: bean['name'], value: bean['title'] ?? ''));
  }
}
