import 'package:flutter/material.dart';
import 'package:flutter_easyrefresh/easy_refresh.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:jcs_airport/services/api.dart';
import '../../../../consts/http_config.dart';

///  力量调度底部列表
class PowerList extends StatefulWidget {
  final String alarmId;
  final String type;
  PowerList(this.alarmId, this.type);

  @override
  _PowerListState createState() => _PowerListState();
}

class _PowerListState extends State<PowerList> {
  GlobalKey globalKey2 = GlobalKey();
  ScrollController scrollController = ScrollController();
  final EasyRefreshController _controllers = EasyRefreshController();
  List powerList = List();

  @override
  void initState() {
    super.initState();
    loadData();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
        child: Expanded(
            child: Column(children: <Widget>[
      Expanded(
          child: Stack(children: <Widget>[
        Center(
            child: EasyRefresh(
                controller: _controllers,
                footer: MaterialFooter(),
                header: MaterialHeader(),
                child: ListView.builder(
                    itemCount: powerList.length,
                    shrinkWrap: true,
                    itemBuilder: (BuildContext context, int index) {
                      Map item = powerList[index];
                      ListViewItemModel listViewItemModel =
                          ListViewItemModel(title: item['name'], item: item);
                      return Expanded(
                        child: PowerListViewItem(
                            listViewItemModel: listViewItemModel,
                            contentWidget: Padding(
                                padding: const EdgeInsets.all(5.0),
                                child: InkWell(
                                    onTap: () {},
                                    child: Column(children: [
                                      LabelValue(
                                          label: '地    址',
                                          value: item['address'] ?? ''),
                                      const SizedBox(height: 5),
                                      LabelValue(
                                          label: '负责人',
                                          value: item['chargePerson'] ?? ''),
                                      const SizedBox(height: 5),
                                      LabelValue(
                                          label: '电    话',
                                          value: item['tel'] ?? '')
                                    ])))),
                      );
                    }),
                onRefresh: () async {
                  await Future.delayed(const Duration(seconds: 1), () {});
                },
                onLoad: () async {
                  await Future.delayed(const Duration(seconds: 1), () {});
                }))
      ]))
    ])));
  }

  Future<void> loadData() async {
    dynamic query = {'current': '1', 'size': '100'};
    query['type'] = widget.type;
    query['alertId'] = widget.alarmId;
    Map<String, dynamic> data = await API.getTransferList(query);
    print(data);
    setState(() {
      powerList = data['records'];
    });
  }
}

class PowerListViewItem extends StatelessWidget {
  ///数据model
  ListViewItemModel listViewItemModel;

  ///自定义item内容
  final Widget contentWidget;

  PowerListViewItem(
      {@required this.listViewItemModel, @required this.contentWidget});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(left: 6, top: 6, right: 6),
      decoration: BoxDecoration(boxShadow: [CoreColors.boxShadow]),
      child: ClipRRect(
        borderRadius: FormStyles.borderRadius,
        child: Container(
          decoration: BoxDecoration(
              color: Colors.white,
              border: listViewItemModel.hasState
                  ? Border(
                      left: BorderSide(
                          color: listViewItemModel.stateColor, width: 10))
                  : null),
          child: InkWell(
            onTap: () {
              if (listViewItemModel.onclick != null) {
                listViewItemModel.onclick();
              }
              //Scaffold.of(context).showSnackBar(new SnackBar(content: new Text("click")));
            },
            child: Flex(direction: Axis.vertical, children: [
              Padding(
                padding: const EdgeInsets.only(left: 5),
                child: Flex(
                  direction: Axis.horizontal,
                  children: [
                    Container(
                      width: 97,
                      child: (listViewItemModel.item['img'] != null &&
                              listViewItemModel.item['img'] != '')
                          ? Image.network(
                              '${HttpConfig.GateWayURL}${listViewItemModel.item['img']}',
                              width: 60,
                              height: 60,
                            )
                          : Image.asset(
                              'assets/images/no_data.png',
                              width: 60,
                              height: 60,
                            ),
                    ),
                    Expanded(
                        child: Flex(
                      direction: Axis.vertical,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        listViewItemModel.hasTitle
                            ? Padding(
                                padding: const EdgeInsets.all(5.0),
                                child: Text(
                                  listViewItemModel.title,
                                  style: TextStyle(fontSize: 16),
                                ),
                              )
                            : Container(),
                        contentWidget
                      ],
                    ))
                  ],
                ),
              ),
              listViewItemModel.hasFooter
                  ? Container(
                      color: Color.fromRGBO(250, 250, 250, 1.0),
                      child: Row(children: [
                        Padding(
                          padding: const EdgeInsets.only(
                              left: 10, top: 5, right: 5, bottom: 5),
                          child: Text(
                            listViewItemModel.footer,
                            style: TextStyle(color: Colors.black54),
                          ),
                        ),
                      ]),
                    )
                  : Container(),
            ]),
          ),
        ),
      ),
    );
  }
}

class ListViewItemModel {
  ///是否含有状态
  bool hasState;

  ///状态颜色
  Color stateColor;

  ///标题内容
  bool hasTitle;

  ///是否含有标题
  String title;

  ///页脚内容
  bool hasFooter;

  ///是否含有页脚
  String footer;

  ///列表点击事件
  Function onclick;

  dynamic item;

  ListViewItemModel(
      {this.hasState = false,
      this.stateColor,
      this.hasTitle = true,
      this.title,
      this.hasFooter = false,
      this.item,
      this.footer,
      this.onclick})
      : assert(hasState || stateColor == null, 'stateColor不能为空'),
        assert(hasTitle || title == null, 'title不能为空'),
        assert(hasFooter || footer == null, 'footer不能为空');
}
