import 'package:flutter/material.dart';
import 'package:flutter_svg_provider/flutter_svg_provider.dart';

class ImageButton extends StatelessWidget {
  final String src;
  final double size;
  final double imageSize;
  final VoidCallback onTap;
  final Alignment alignment;
  final Color splashColor;
  final Color highlightColor;

  const ImageButton(
      {@required this.src,
      this.onTap,
      this.size = 30,
      this.imageSize = 18,
      this.alignment = Alignment.center,
      this.splashColor = Colors.transparent,
      this.highlightColor = Colors.transparent});

  @override
  Widget build(BuildContext context) {
    return InkWell(
      splashColor: splashColor,
      highlightColor: highlightColor,
      child: Container(
          alignment: alignment,
          width: size,
          height: size,
          child: Image(
            image: Svg(
              src,
              size: Size(imageSize.toDouble(), imageSize.toDouble()),
            ),
          )),
      onTap: onTap,
    );
  }
}
