import 'package:flutter/material.dart';

class LoadingDialog extends Dialog {
  final bool barrierDismissible;

  const LoadingDialog({Key key, this.barrierDismissible = true}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () {
        if (!barrierDismissible) {
          Navigator.of(context).pop();
        }
        return Future.value(false);
      },
      child: Material(
        //创建透明层
        type: MaterialType.transparency, //透明类型
        child: Container(
          child: Stack(
            fit: StackFit.expand,
            children: <Widget>[
              GestureDetector(onTap: () {
                if (!barrierDismissible) {
                  Navigator.of(context).pop();
                }
              }),
              const Center(
                child: CircularProgressIndicator(),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
