import 'package:get/get.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:jcs_airport/services/api.dart';
import 'package:jcs_airport/view/common/base_choose_person.dart';

///@Description     陪同检查人
///@author          helinlin
///@create          2021-09-03 15:32
class ChooseFireproofSupervisionAccompanyPerson extends BaseChoose {
  String originalId;

  ChooseFireproofSupervisionAccompanyPerson(this.originalId, {Map person, bool multi, List<Map> persons})
      : super(person: person, multi: multi, persons: persons);

  @override
  BaseChooseState getBaseChoosePersonState() => ChooseFireproofSupervisionAccompanyPersonState(originalId);
}

class ChooseFireproofSupervisionAccompanyPersonState extends BaseChooseState {
  String originalId;

  ChooseFireproofSupervisionAccompanyPersonState(this.originalId);

  @override
  Future<void> getData() async {
    Future.delayed(Duration.zero, () async {
      MsgBox.showProgressDialog(context, content: '加载中，请稍后...');
      var data = await API.accompanyJcsOrgUsrList(originalId);
      Get.back();
      setState(() {
        if (data != null) {
          persons.addAll(data);
        }
      });
    });
  }

  @override
  String getIdKey() => 'sequenceNbr';

  @override
  String getNameKey() => 'bizOrgName';
}
