import 'package:flutter/cupertino.dart';
import 'package:get/get.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:jcs_airport/services/api.dart';
import 'package:jcs_airport/view/common/base_choose_department.dart';
import 'package:jcs_airport/view/common/tree_view.dart';

///@Description     被检查单位
///@author          helinlin
///@create          2021-09-03 15:32
class ChooseFireproofSupervisionDepartment extends BaseTreeChoose {
  @override
  BaseTreeChooseState getBaseBaseChooseDepartmentState() => ChooseFireproofSupervisionDepartmentState();

  ChooseFireproofSupervisionDepartment(Map chooseDepartment) : super(chooseDepartment: chooseDepartment);
}

class ChooseFireproofSupervisionDepartmentState extends BaseTreeChooseState {
  @override
  Future<void> getData() async {
    Future.delayed(Duration.zero, () async {
      MsgBox.showProgressDialog(context, content: '加载中，请稍后...');
      var data = await API.jcsOrgUsrListCompany();
      Get.back();
      setState(() {
        if (data != null) {
          departments.addAll(data['records']);
        }
      });
    });
  }

  @override
  String getIdKey() => 'sequenceNbr';

  @override
  String getNameKey() => 'bizOrgName';
}
/*

class ChooseFireproofSupervisionDepartment extends StatefulWidget {
  Map chooseDepartment;

  ChooseFireproofSupervisionDepartment({this.chooseDepartment});

  @override
  _ChooseFireproofSupervisionDepartmentState createState() => _ChooseFireproofSupervisionDepartmentState();
}

class _ChooseFireproofSupervisionDepartmentState extends ChooseTreeState<ChooseFireproofSupervisionDepartment> {
  @override
  Future getData() => API.jcsOrgUsrListCompany();

  @override
  String getKey() => 'sequenceNbr';

  @override
  String getName() => 'bizOrgName';
}
*/
