import 'package:amos_iot_ui/listItem/list_view_item.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:jcs_airport/consts/colors.dart';
import 'package:jcs_airport/services/api.dart';
import 'package:jcs_airport/view/common/base_dropdown_filter.dart';
import 'package:jcs_airport/view/workBench/fireproofSupervision/planCheck/plan_check.dart';
import 'package:jcs_airport/view/workBench/fireproofSupervision/planCheck/plan_check_detail.dart';

///@Description     计划检查详情
///@author          helinlin
///@create          2021-09-01 11:41
class PlanCheckPoint extends StatefulWidget {
  final String planId;
  final String planTaskId;
  final String routeId;
  final String taskName;
  final bool isExecutor;
  final bool canExecute;

  const PlanCheckPoint(this.planId, this.planTaskId, this.routeId, this.taskName, this.isExecutor, this.canExecute);

  @override
  _PlanCheckPointState createState() => _PlanCheckPointState();
}

class _PlanCheckPointState extends PlanCheckState<PlanCheckPoint> {

  @override
  List<DropdownMenuBuilderEntity> getDropdownMenuContentEntity() {
    return <DropdownMenuBuilderEntity>[
      DropdownMenuBuilderEntity(scopeSelectIndex, scope),
      DropdownMenuBuilderEntity(dateSelectIndex, date),
      DropdownMenuBuilderEntity(statusSelectIndex, status),
      //DropdownMenuBuilderEntity(orderTypeSelectIndex, orderType)
    ];
  }

  @override
  String pageTitle() => widget.taskName;

  @override
  void getData() {
    Future.delayed(Duration.zero, () async {
      MsgBox.showProgressDialog(context, content: '加载中，请稍后...');
      var data = await API.supervisionQueryPlanTaskDetail(
          filterData..addAll({'pageNumber': page.current, 'pageSize': page.size, 'planTaskId': widget.planTaskId}));
      Get.back();
      if (data != null) {
        if ((data['points'] ?? []).length == 0) {
          refreshController.loadNoData();
          return;
        }
        setState(() {
          dataList.addAll(data['points']['content'].cast<Map<String, Object>>());
        });
      }
      refreshController.refreshCompleted();
      refreshController.loadComplete();
    });
  }

  @override
  Future<void> getFinishStatus() async {
    var data = await API.supervisionPlanTaskDetailIsStatus();
    if (data != null) {
      data.forEach((element) {
        status.add({'title': element['name'], 'value': element['value']});
      });
    }
  }

  @override
  Widget buildListItem(BuildContext context, int index) {
    Map<String, Object> item = dataList[index];
    ListViewItemModel listViewItemModel = ListViewItemModel(
        hasTitle: false,
        hasState: true,
        stateColor: AMOSColors.fireproofSupervisionPointStatusColor(item['finish']),
        hasFooter: true,
        footer: "编号： ${item['pointNO']}",
        onclick: () async {
          await Get.to(PlanCheckDetail(
              item['originalId'],
              item['pointId'],
              item['name'],
              item['pointNO'],
              widget.taskName,
              widget.planTaskId,
              widget.planId,
              widget.routeId,
              widget.isExecutor && widget.canExecute && (item['finish'] == 0 || item['finish'] == 1)));
          onRefresh();
        });
    return ListViewItem(
      listViewItemModel: listViewItemModel,
      contentWidget: Padding(
        padding: const EdgeInsets.all(5.0),
        child: Column(
          children: [
            Row(
              children: [
                Expanded(
                  flex: 4,
                  child: Row(
                    children: [
                      Text(
                        (item['name'] ?? '').toString(),
                        style: const TextStyle(fontSize: 16),
                      ),
                    ],
                  ),
                ),
                Text(
                  item['isFinishDesc'] ?? '',
                  style: TextStyle(color: AMOSColors.fireproofSupervisionPointStatusColor(item['finish'])),
                ),
              ],
            ),
            const SizedBox(
              height: 5,
            ),
            Row(
              children: [
                Expanded(
                  child: Row(
                    children: [
                      const Text('检  查  项：'),
                      const SizedBox(
                        width: 5,
                      ),
                      Text((item['itemNum'] ?? '').toString()),
                    ],
                  ),
                ),
                Expanded(
                  child: Row(
                    children: [
                      const Text('剩        余：'),
                      const SizedBox(
                        width: 5,
                      ),
                      Text((int.parse((item['itemNum'] ?? '0').toString()) - int.parse((item['executedNum'] ?? '0').toString()) ??
                              '')
                          .toString()),
                    ],
                  ),
                ),
              ],
            ),
            const SizedBox(
              height: 5,
            ),
            Row(
              children: [
                Expanded(
                  child: Row(
                    children: [
                      const Text('安全隐患：'),
                      const SizedBox(
                        width: 5,
                      ),
                      Text((item['safetyDangerNum'] ?? '').toString()),
                    ],
                  ),
                ),
                Expanded(
                  child: Row(
                    children: [
                      const Text('重大隐患：'),
                      const SizedBox(
                        width: 5,
                      ),
                      Text((item['majorDangerNum'] ?? 0).toString()),
                    ],
                  ),
                ),
              ],
            ),
          ],
        ),
      ),
    );
  }
}
