import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:jcs_airport/consts/styles.dart';
import 'package:jcs_airport/services/api.dart';

class ChooseFireFightingSystem extends StatefulWidget {
  final Map system;

  const ChooseFireFightingSystem(this.system);

  @override
  _ChooseFireFightingSystemState createState() => _ChooseFireFightingSystemState();
}

class _ChooseFireFightingSystemState extends State<ChooseFireFightingSystem> {
  List systems = [];
  final GlobalKey<ScaffoldState> _scaffoldKey = GlobalKey<ScaffoldState>();

  @override
  void initState() {
    super.initState();
    initData();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      resizeToAvoidBottomInset: false,
      key: _scaffoldKey,
      appBar: AppBar(
        title: const Text('请选择'),
      ),
      body: Column(
        children: [
          Expanded(
            child: systems.isNotEmpty ? buildListView(systems) : Container(),
          ),
          Container(
            padding: const EdgeInsets.all(10),
            child: Row(
              children: [
                Expanded(
                  child: FlatButton(
                    color: Colors.blueAccent,
                    height: 40,
                    onPressed: () {
                      Navigator.pop(context, widget.system);
                    },
                    child: const Text(
                      '确定',
                      style: TextStyle(color: Colors.white),
                    ),
                  ),
                ),
              ],
            ),
          )
        ],
      ),
    );
  }

  ListView buildListView(List system) {
    return ListView.builder(
        shrinkWrap: true,
        itemBuilder: (BuildContext context, int index) {
          return InkWell(
            onTap: () {
              setState(() {
                widget.system.addAll(system[index]);
              });
            },
            child: Row(
              children: [
                Checkbox(
                    value: system[index]['id'] == widget.system['id'],
                    onChanged: (value) {
                      setState(() {
                        widget.system.addAll(system[index]);
                      });
                    }),
                Expanded(
                    child: ListTile(
                        title: Text(
                  system[index]['name'] ?? '',
                  style: const TextStyle(fontSize: CoreStyles.textSizeSmall),
                ))),
              ],
            ),
          );
        },
        itemCount: system.length);
  }

  Future<void> initData() async {
    Future.delayed(Duration.zero, () async {
      MsgBox.showProgressDialog(context, content: '加载中，请稍后...');
      var data = await API.fireFightSysPage({'current': 0, 'size': 9999,'type':3});
      Get.back();
      if (data != null) {
        setState(() {
          systems = data['records'];
        });
      }
    });
  }
}
