import 'package:flutter/material.dart';

///详细参数
class DetailParameter extends StatefulWidget {
  final Map _data;

  const DetailParameter(this._data);

  @override
  _DetailParameterState createState() => _DetailParameterState();
}

class _DetailParameterState extends State<DetailParameter> {
  int _index = 0;

  @override
  Widget build(BuildContext context) {
    return Card(
      child: SingleChildScrollView(
        child: Column(
          children: [
            Container(
              height: 35,
              padding: const EdgeInsets.symmetric(horizontal: 15),
              color: const Color(0xff00ccff),
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                children: const [
                  Expanded(
                    child: Text(
                      '详细参数',
                    ),
                  ),
                ],
              ),
            ),
            ..._buildContent(),
          ],
        ),
      ),
    );
  }

  List<Widget> _buildContent() {
    switch (widget._data['resourceType']) {
      case 'crane': //消防水鹤
        return [
          ///消防水鹤
          _buildRow('高度(cm):', (widget._data['height'] ?? '').toString()),
          _buildRow('供水单位:', (widget._data['waterSupplyName'] ?? '').toString()),
          _buildRow('所属网管名称:', (widget._data['pipeNetwork'] ?? '').toString()),
          _buildRow('消防给水管网形式:', (widget._data['pipeTypeName'] ?? '').toString()),
          _buildRow('管网直径(cm):', (widget._data['pipeDiameter'] ?? '').toString()),
          _buildRow('加水车道数量:', (widget._data['waterfillingLaneNum'] ?? '').toString()),
          _buildRow('进水管网直径(cm):', (widget._data['inletPipeDiameter'] ?? '').toString()),
          _buildRow('出水管网直径(cm):', (widget._data['outletPipeDiameter'] ?? '').toString()),
          _buildRow('水源可用状态:', (widget._data['status'] ?? '').toString()),
          _buildRow('所属路段:', (widget._data['section'] ?? '').toString()),
        ];
        break;
      case 'hydrant': //消防栓
        return [
          ///消防栓
          _buildRow('消防栓类型:', (widget._data['type'] ?? '').toString()),
          _buildRow('消防栓系统类型:', (widget._data['systemType'] ?? '').toString()),
          _buildRow('消防栓放置形式:', (widget._data['placeForm'] ?? '').toString()),
          _buildRow('消防水带接口:', (widget._data['hoseConnection'] ?? '').toString()),
          _buildRow('取水形势:', (widget._data['intakeForm'] ?? '').toString()),
          _buildRow('所属网管名称:', (widget._data['pipeNetwork'] ?? '').toString()),
          _buildRow('消防给水管网形式:', (widget._data['pipeTypeName'] ?? '').toString()),
          _buildRow('管网直径(cm):', (widget._data['pipeDiameter'] ?? '').toString()),
          _buildRow('道路路口路段:', (widget._data['roadJunctionInfo'] ?? '').toString()),
          _buildRow('供水单位:', (widget._data['waterSupplyName'] ?? '').toString()),
          _buildRow('消防设施状况:', (widget._data['facilitiesCategory'] ?? '').toString()),
        ];
        break;
      case 'natural': //天然水源
        return [
          ///天然水源
          _buildRow('高度:', (widget._data['height'] ?? '').toString()),
          _buildRow('水源类型:', (widget._data['type'] ?? '').toString()),
          _buildRow('容积(m3):', (widget._data['volume'] ?? '').toString()),
          _buildRow('面积(m2):', (widget._data['area'] ?? '').toString()),
          _buildRow('水源可用状态:', (widget._data['status'] ?? '').toString()),
          _buildRow('有无枯水期:', (widget._data['hasDrySeason'] ?? '').toString()),
          _buildRow('水质情况:', (widget._data['qualitySituationInfo'] ?? '').toString()),
          _buildRow('四级变化:', (widget._data['seasonChangeInfo'] ?? '').toString()),
          _buildRow('枯水期跨度:', (widget._data['dryPeriodSpan'] ?? '').toString()),
        ];
        break;
      case 'pool': //水池
        return [
          ///水池
          _buildRow('容积(m2):', (widget._data['volume'] ?? '').toString()),
          _buildRow('取水形式:', (widget._data['intakeForm'] ?? '').toString()),
          _buildRow('取水高度(cm):', (widget._data['intakeHeight'] ?? '').toString()),
          _buildRow('水源标高差(cm):', (widget._data['elevationDifference'] ?? '').toString()),
          _buildRow('所属路段:', (widget._data['section'] ?? '').toString()),
          _buildRow('停车位置:', (widget._data['parkingPosition'] ?? '').toString()),
          _buildRow('停车数量(个):', (widget._data['parkingNum'] ?? '').toString()),
          _buildRow('消防给水管网形式:', (widget._data['pipeTypeName'] ?? '').toString()),
          _buildRow('供水单位:', (widget._data['waterSupplyName'] ?? '').toString()),
          _buildRow('水源可用状态:', (widget._data['status'] ?? '').toString()),
        ];
        break;
      default:
        return [];
    }
  }

  Widget _buildRow(String title, String value) {
    return Container(
      height: 35,
      padding: const EdgeInsets.symmetric(horizontal: 15),
      color: _index++ % 2 == 0 ? Colors.white : const Color(0xffefeff4),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [Expanded(flex: 2, child: Text(title)), Expanded(flex: 3, child: Text(value))],
      ),
    );
  }
}
