import 'package:flutter/material.dart';
import 'package:jcs_airport/consts/colors.dart';
import 'package:jcs_airport/consts/styles.dart';
import 'package:jcs_airport/view/workBench/maintenance/maintenanceRecord/record.dart';
import 'package:jcs_airport/viewmodel/facility_filter.dart';

///装备详情维保信息Tab
class MaintenanceTabInfo extends StatefulWidget {
  final equipmentCategory;
  final String fireFacilityCode;
  const MaintenanceTabInfo(this.equipmentCategory,[this.fireFacilityCode]);

  @override
  _MaintenanceTabInfoState createState() => _MaintenanceTabInfoState();
}

class _MaintenanceTabInfoState extends State<MaintenanceTabInfo> {
  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.symmetric(horizontal: 2),
      child: Column(
        children: [
          Card(
            child: Container(
              padding: const EdgeInsets.all(15),
              child: Column(
                children: [
                  Row(
                    children: [
                      const Text(
                        '维保状态：',
                        style: TextStyle(fontSize: CoreStyles.textSizeSmall),
                      ),
                      const SizedBox(
                        width: 50,
                      ),
                      (widget.equipmentCategory['statusText'] != null && widget.equipmentCategory['statusText'] != '')
                          ? Container(
                              decoration: BoxDecoration(
                                  color: AMOSColors.maintenanceEquipmentRecordStatusColor(
                                      widget.equipmentCategory['statusText'] ?? ''),
                                  borderRadius: const BorderRadius.all(Radius.circular(20))),
                              child: Text(
                                widget.equipmentCategory['statusText'] ?? '',
                                style: const TextStyle(fontSize: CoreStyles.textSizeMin, color: Colors.white),
                              ),
                              padding: const EdgeInsets.symmetric(horizontal: 8, vertical: 0.5),
                              margin: const EdgeInsets.only(top: 4),
                            )
                          : Container(),
                    ],
                  ),
                  const SizedBox(
                    height: 5,
                  ),
                  Row(
                    children: [
                      const Text('最新维保时间：'),
                      Text(widget.equipmentCategory['maintenanceTime'] ?? ''),
                    ],
                  ),
                  const SizedBox(
                    height: 5,
                  ),
                  Row(
                    children: [
                      const Text('维保周期 (月)：'),
                      Text((widget.equipmentCategory['maintenanceCycle'] ?? '').toString()),
                    ],
                  ),
                  const SizedBox(
                    height: 5,
                  ),
                  Row(
                    children: [
                      const Text('到期维保时间：'),
                      Text(widget.equipmentCategory['maintenanceExpirationTime'] ?? ''),
                    ],
                  ),
                ],
              ),
            ),
          ),
          Expanded(
              child: RecordContent(
            showFilter: false,
            fireFacilityCode:widget.fireFacilityCode
          )),
        ],
      ),
    );
  }
}
