import 'dart:convert';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:jcs_airport/services/api.dart';

import 'equipmentDetail/base_info.dart';
import 'equipmentDetail/detail_parameter.dart';
import 'equipmentDetail/location_map.dart';
import 'equipmentDetail/maintenance_tab_info.dart';

///水源详情
class EquipmentCategoryDetail extends StatefulWidget {
  final Map equipmentCategory;

  const EquipmentCategoryDetail(this.equipmentCategory);

  @override
  _EquipmentCategoryDetailState createState() => _EquipmentCategoryDetailState();
}

class _EquipmentCategoryDetailState extends State<EquipmentCategoryDetail> with SingleTickerProviderStateMixin {
  int tabIndex = 0;
  TabController _tabController;
  Map _data = {};

  @override
  void initState() {
    super.initState();
    _tabController = TabController(vsync: this, length: 4);
    _tabController.animateTo(tabIndex);
    _initData();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('报修任务'),
        bottom: TabContainer(
          color: Colors.white,
          child: TabBar(
            labelColor: Colors.blueAccent,
            unselectedLabelColor: Colors.black54,
            indicatorColor: Colors.lightBlue,
            indicatorSize: TabBarIndicatorSize.label,
            isScrollable: false,
            tabs: const [
              Tab(text: '基本信息'),
              Tab(text: '详细参数'),
              Tab(text: '方位图'),
              Tab(text: '维保信息'),
            ],
            controller: _tabController,
          ),
        ),
      ),
      body: TabBarView(
        controller: _tabController,
        children: [
          BaseInfo(_data),
          DetailParameter(_data),
          LocationMap(_data),
          MaintenanceTabInfo(widget.equipmentCategory),
        ],
      ),
    );
  }

  void _initData() {
    Future.delayed(Duration.zero, () {
      MsgBox.showProgressDialog(context, content: '加载中，请稍后...');
      Future.wait([waterResource()]).whenComplete(() => Get.back());
    });
  }

  Future<void> waterResource() async {
    var data = await API.waterResource(widget.equipmentCategory['fireFacilityId']);
    if (data != null) {
      setState(() {
        data['orientationImg'] = json.decode(data['orientationImg'] ?? []);
        data['realityImg'] = json.decode(data['realityImg'] ?? []);
        _data = data;
      });
    }
  }
}
