import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:jcs_airport/services/api.dart';

class Verify extends StatefulWidget {
  final String sequenceNbr;

  const Verify(this.sequenceNbr);

  @override
  _VerifyState createState() => _VerifyState();
}

class _VerifyState extends State<Verify> {
  final GlobalKey<FormState> _formKey = GlobalKey<FormState>();
  String _verifyOpinion = '';
  Map<String, Object> submitData = {};


  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('故障设备维修验收'),
      ),
      body: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Expanded(
            child: Form(
              key: _formKey,
              child: FormItem(
                label: '验收意见:',
                formfield: ITextFormField(
                    value: _verifyOpinion,
                    maxLines: 4,
                    validator: ValidatorMulti([ValidatorRequired(errorText: '请输入验收意见')]),
                    hintText: '请输入验收意见',
                    onChanged: (val) {
                      setState(() {
                        _verifyOpinion = val;
                      });
                    }),
              ),
            ),
          ),
          Container(
            padding: const EdgeInsets.all(15),
            child: Row(
              children: [
                Expanded(
                    child: FlatButton(
                  color: const Color.fromRGBO(200, 200, 200, 1),
                  height: 40,
                  onPressed: () {
                    onSubmit(context, 1);
                  },
                  child: const Text(
                    '不同意',
                    style: TextStyle(color: Colors.red),
                  ),
                )),
                const SizedBox(
                  width: 5,
                ),
                Expanded(
                    child: FlatButton(
                  color: Colors.blueAccent,
                  height: 40,
                  onPressed: () {
                    onSubmit(context, 0);
                  },
                  child: const Text(
                    '同意验收',
                    style: TextStyle(color: Colors.white),
                  ),
                )),
              ],
            ),
          ),
        ],
      ),
    );
  }

  void onSubmit(BuildContext context, int type) {
    if (_formKey.currentState.validate()) {
      submitData['condition'] = type;
      submitData['faultId'] = widget.sequenceNbr;
      submitData['verifyOpinion'] = _verifyOpinion;
      MsgBox.showConfirmDialog(context, submit);
    }
  }

  Future<void> submit() async {
    MsgBox.showProgressDialog(context);
    var result = await API.failureMaintainVerify(submitData);
    Get.back();
    if (result != null && result == true) {
      Get.back();
    } else {
      ToastUtils.showToast('响应异常，提交失败！！');
    }
  }
}
