import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:jcs_airport/utils/GetConfig.dart';
import 'package:jcs_airport/consts/colors.dart';
import 'package:jcs_airport/services/api.dart';
import 'package:jcs_airport/viewmodel/name_value.dart';
import 'package:jcs_airport/viewmodel/facility_filter.dart';

class FilterPage extends StatefulWidget {
  FilterPage(this.facilityFilter, {this.callback});

  final callback;
  final FacilityFilter facilityFilter;

  @override
  State<StatefulWidget> createState() => _FilterPageState();
}

class _FilterPageState extends State<FilterPage> {
  String _warehouseStructureName = '';
  String _status = '';
  String _fireFightingSystem = '';
  String _fireFightingSystemName = '全部';
  String _fireEquipmentName = '';
  String _fireEquipmentCode = '';

  String theme = '';

  List fireSystemList = [];

  @override
  void initState() {
    super.initState();
    if (widget.facilityFilter != null) {
      _warehouseStructureName = widget.facilityFilter.warehouseStructureName ?? '';
      _status = widget.facilityFilter.status ?? '';
      _fireFightingSystem = widget.facilityFilter.fireFightingSystem ?? '';
      _fireEquipmentName = widget.facilityFilter.fireEquipmentName ?? '';
      _fireEquipmentCode = widget.facilityFilter.fireEquipmentCode ?? '';
    }
    getBuild();
    initConfig();
  }

  initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text(
          '物联设施筛选',
        ),
      ),
      body: ListView.builder(
        itemCount: 1,
        itemBuilder: (BuildContext context, int index) {
          return Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: <Widget>[
              Container(
                padding: const EdgeInsets.only(left: 10),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    const Padding(
                      padding: EdgeInsets.only(top: 15),
                    ),
                    const Text('消防系统'),
                    const Padding(
                      padding: EdgeInsets.only(top: 5),
                    ),
                    GestureDetector(
                        child: Container(
                          height: 40,
                          width: MediaQuery.of(context).size.width - 20,
                          padding: const EdgeInsets.only(bottom: 5),
                          decoration: BoxDecoration(
                            color: Colors.grey[100],
                          ),
                          child: Stack(
                            children: <Widget>[
                              Container(
                                alignment: Alignment.centerLeft,
                                padding: const EdgeInsets.only(left: 5),
                                child: Text(_fireFightingSystemName),
                              ),
                              Container(
                                alignment: Alignment.centerRight,
                                child: Icon(
                                  Icons.keyboard_arrow_right,
                                  size: 14,
                                  color: GetConfig.getColor(theme),
                                ),
                              )
                            ],
                          ),
                        ),
                        onTap: () {
                          showDialog<Null>(
                            context: context,
                            builder: (BuildContext context) {
                              return SimpleDialog(
                                  children: fireSystemList.map((f) {
                                return Column(
                                  children: <Widget>[
                                    SimpleDialogOption(
                                      child: Text(f.name),
                                      onPressed: () {
                                        Navigator.of(context).pop();
                                        print(f.name);
                                        setState(() {
                                          _fireFightingSystem = f.value.toString();
                                          _fireFightingSystemName = f.name;
                                        });
                                      },
                                    ),
                                    const Divider(
                                      height: 1,
                                    )
                                  ],
                                );
                              }).toList());
                            },
                          );
                        })
                  ],
                ),
              ),
              Container(
                padding: const EdgeInsets.only(left: 10),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    const Padding(
                      padding: EdgeInsets.only(top: 15),
                    ),
                    const Text('设备名称'),
                    const Padding(
                      padding: EdgeInsets.only(top: 5),
                    ),
                    GestureDetector(
                        child: Container(
                      height: 40,
                      width: MediaQuery.of(context).size.width - 20,
                      padding: const EdgeInsets.only(bottom: 5),
                      decoration: BoxDecoration(
                        color: Colors.grey[100],
                      ),
                      child: Stack(
                        children: <Widget>[
                          Container(
                              alignment: Alignment.centerLeft,
                              padding: const EdgeInsets.only(left: 5),
                              child: TextField(
                                  // controller: TextEditingController(text: _fireEquipmentName ?? '') ,

                                  controller: TextEditingController.fromValue(TextEditingValue(
                                    // 设置内容
                                      text:  _fireEquipmentName ?? '',
                                      // 保持光标在最后
                                      selection: TextSelection.fromPosition(TextPosition(
                                          affinity: TextAffinity.downstream,
                                          offset: _fireEquipmentName.length)))),




                                  onChanged: (value) {
                                setState(() {
                                  _fireEquipmentName = value;
                                });
                              }))
                        ],
                      ),
                    ))
                  ],
                ),
              ),
              Container(
                padding: const EdgeInsets.only(left: 10),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    const Padding(
                      padding: EdgeInsets.only(top: 15),
                    ),
                    const Text('设备编码'),
                    const Padding(
                      padding: EdgeInsets.only(top: 5),
                    ),
                    GestureDetector(
                        child: Container(
                      height: 40,
                      width: MediaQuery.of(context).size.width - 20,
                      padding: const EdgeInsets.only(bottom: 5),
                      decoration: BoxDecoration(
                        color: Colors.grey[100],
                      ),
                      child: Stack(
                        children: <Widget>[
                          Container(
                              alignment: Alignment.centerLeft,
                              padding: const EdgeInsets.only(left: 5),
                              child: TextField(
                                  // controller: TextEditingController(text: _fireEquipmentCode ?? '') ,

                                  controller: TextEditingController.fromValue(TextEditingValue(
                                    // 设置内容
                                      text:  _fireEquipmentCode ?? '',
                                      // 保持光标在最后
                                      selection: TextSelection.fromPosition(TextPosition(
                                          affinity: TextAffinity.downstream,
                                          offset: _fireEquipmentCode.length)))),




                                  onChanged: (value) {
                                setState(() {
                                  _fireEquipmentCode = value;
                                });
                              }))
                        ],
                      ),
                    ))
                  ],
                ),
              )
            ],
          );
        },
      ),
      persistentFooterButtons: <Widget>[
        Row(
          children: <Widget>[
            Container(
              width: (MediaQuery.of(context).size.width / 2) - 10,
              height: 40,
              color: const Color.fromRGBO(242, 246, 249, 1),
              child: MaterialButton(
                  onPressed: () {
                    setState(() {
                      // _warehouseStructureName = widget.facilityFilter.warehouseStructureName ?? '';
                      // _status = widget.facilityFilter.status ?? '';
                      // _fireFightingSystem = widget.facilityFilter.fireFightingSystem ?? '';
                      // _fireEquipmentName = widget.facilityFilter.fireEquipmentName ?? '';
                      // _fireEquipmentCode = widget.facilityFilter.fireEquipmentCode ?? '';

                       _warehouseStructureName = '';
                       _status = '';
                       _fireFightingSystem = '';
                       _fireFightingSystemName = '全部';
                       _fireEquipmentName = '';
                       _fireEquipmentCode = '';


                    });
                  },
                  child: const Text('重置', style: TextStyle(color: Colors.black, fontSize: 18))),
            ),
            Container(
              width: (MediaQuery.of(context).size.width / 2) - 10,
              height: 40,
              color: Theme.of(context).primaryColor,
              child: MaterialButton(
                onPressed: () {
                  // FacilityFilter filter = FacilityFilter();
                  widget.facilityFilter.warehouseStructureName = _warehouseStructureName;
                  widget.facilityFilter.status = _status;
                  widget.facilityFilter.fireFightingSystem = _fireFightingSystem;
                  widget.facilityFilter.fireEquipmentName = _fireEquipmentName;
                  widget.facilityFilter.fireEquipmentCode = _fireEquipmentCode;
                  widget.callback(widget.facilityFilter);
                  Navigator.pop(context);
                },
                child: const Text('确定', style: TextStyle(color: Colors.white, fontSize: 18)),
              ),
            )
          ],
        )
      ],
      resizeToAvoidBottomPadding: false,
    );
  }

  Future<void> getBuild() {
    API.getFireSystem().then((data) {
      setState(() {
        data.forEach((system) {
          fireSystemList.add(NameValue(system['name'], num.tryParse(system['id'])));
        });
      });
    });
  }
}
