import 'package:flutter/material.dart';
import 'package:amos_iot_login_tpl/amos_iot_login_tpl.dart';
import 'package:base/view/common/banner_page.dart';
import 'package:equipment_manage/model/vehicle_basic_model.dart';
import 'package:get/get.dart';
import 'package:jcs_airport/routes/routes.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import 'package:flutter/material.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

/// 设备设施基本信息
class FacilityBasic extends StatefulWidget {
  final BasicBean baseBean;

  const FacilityBasic(this.baseBean);

  @override
  _FacilityBasicState createState() => _FacilityBasicState(baseBean);
}

class _FacilityBasicState extends State<FacilityBasic> {
  List<BannerItem> bannerList = [];
  List<dynamic> basicList = [];
  String name = '';
  String qrcode = '';
  String status = '';
  String updateTime = '';
  BasicBean baseBean;
  final String type = '1'; //1为装备 3为车辆
  String equipCode = '';
  String statusname = '';

  _FacilityBasicState(this.baseBean);

  @override
  void initState() {
    super.initState();
    EquipmentBase equipmentBase = baseBean.equipmentBase;
    APIUrlManager.getImageUrl().then((value) {
      //数据处理
      if (equipmentBase?.img != null && equipmentBase.img.length > 0) {
        for (int i = 0; i < equipmentBase.img.length; i++) {
          Img model = equipmentBase.img[i];
          print(value + model.url);
          BannerItem item = BannerItem.defaultBannerItem(
              model.url == null ? ' ' : Utils.completeUrl(value, model.url),
              '');
          setState(() {
            bannerList.add(item);
          });
        }
      }
    });

    statusname = equipmentBase?.status == null ? " " : equipmentBase.status;
    name = equipmentBase?.equipName == null ? " " : equipmentBase.equipName;
    qrcode = equipmentBase?.qrCode == null ? " " : equipmentBase.qrCode;

    status = equipmentBase?.alarmType == null ? " " : equipmentBase.alarmType;
    updateTime = equipmentBase?.brand == null ? " " : equipmentBase.brand;

    equipCode =
        equipmentBase?.equipCode == null ? " " : equipmentBase.equipCode;

    final pream = {
      "name": "分类",
      "title":
          equipmentBase?.categoryName == null ? " " : equipmentBase.categoryName
    };
    basicList.add(pream);
    final pream1 = {
      "name": "所在位置",
      "title":
          equipmentBase?.description == null ? " " : equipmentBase.description
    };
    basicList.add(pream1);

    final pream3 = {
      "name": "入库时间",
      "title":
          equipmentBase?.createTime == null ? " " : equipmentBase.createTime
    };
    basicList.add(pream3);

    final pream4 = {
      "name": "规格型号",
      "title": equipmentBase?.standard == null ? " " : equipmentBase.standard
    };
    basicList.add(pream4);

    final pream5 = {
      "name": "国别",
      "title": equipmentBase?.country == null ? " " : equipmentBase.country
    };
    basicList.add(pream5);

    final pream6 = {
      "name": "保养周期(月)",
      "title": equipmentBase?.maintenanceCycle == null
          ? " "
          : equipmentBase.maintenanceCycle
    };
    basicList.add(pream6);

    final pream7 = {
      "name": "报废年限",
      "title":
          equipmentBase?.expiryDate == null ? " " : equipmentBase.expiryDate
    };
    basicList.add(pream7);

    final pream8 = {
      "name": "生产厂商",
      "title": baseBean.manufacturerInfo?.name == null
          ? " "
          : baseBean.manufacturerInfo.name
    };
    basicList.add(pream8);

    final pream9 = {
      "name": "品牌",
      "title": equipmentBase?.brand == null ? " " : equipmentBase.brand
    };
    basicList.add(pream9);
  }

  @override
  Widget build(BuildContext context) {
    return SingleChildScrollView(
        child: Column(children: <Widget>[
      Material(
          color: Colors.white,
          //圆角
          borderRadius: BorderRadius.circular(10.0),
          shadowColor: Colors.black38,
          elevation: 8.0,
          child: Column(children: [
            //banner图
            BannerWidget(
              180.0,
              bannerList,
              bannerPress: (pos, item) {
                print('第 $pos 点击了');
              },
            ),
            InkWell(
                onTap: () {
                  Get.toNamed(JCSRoutes.alarmInfo,
                      arguments:
                          PlatformMenu(frontComponent: 'jq', icon: equipCode));
                },
                child: Container(
                    padding:
                        const EdgeInsets.only(left: 8, top: 10, bottom: 10),
                    alignment: Alignment.centerLeft,
                    child: Flex(direction: Axis.horizontal, children: [
                      Expanded(
                          child: Flex(
                              direction: Axis.vertical,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                            Container(
                              alignment: Alignment.centerLeft,
                              child: Row(children: [
                                Text(
                                  name,
                                  style: const TextStyle(
                                      fontSize: 15, color: Color(0xff333333)),
                                  textAlign: TextAlign.left,
                                ),
                                // GradientButton(
                                //   color: Colors.red,
                                //   child: Text(statusname),
                                //   borderRadius: BorderRadius.circular(5),

                                // ),
                                statusname.isNotEmpty&&statusname!='正常'  ?Container(
                                  margin: const EdgeInsets.only(left: 40),
                                  //设置 child 居中
                                  alignment: const Alignment(0, 0),
                                  height: 20,
                                  width: 50,
                                  //边框设置
                                  decoration: BoxDecoration(
                                    //背景
                                    color: Colors.red,
                                    //设置四周圆角 角度
                                    borderRadius:
                                        BorderRadius.all(Radius.circular(10.0)),
                                    //设置四周边框
                                    border:
                                        Border.all(width: 1, color: Colors.red),
                                  ),
                                  child: Text(statusname),
                                ):Container(),



                              ]),
                            ),
                            Container(
                                margin: const EdgeInsets.only(top: 10),
                                child: Row(children: [
                                  Text('实时状态：',
                                      style: const TextStyle(
                                          fontSize: 12,
                                          color: Color(0xff666666)),
                                      textAlign: TextAlign.left),
                                  Container(width: 10),
                                  Text(status,
                                      style: const TextStyle(
                                          fontSize: 12,
                                          color: Color(0xff666666)),
                                      textAlign: TextAlign.left),
                                  Container(width: 20),
                                  const Text('更新时间：',
                                      style: TextStyle(
                                          fontSize: 12,
                                          color: Color(0xff666666)),
                                      textAlign: TextAlign.left),
                                  Container(width: 5),
                                  Expanded(
                                      child: Text(
                                          baseBean.equipmentBase.alarmTime ??
                                              '',
                                          style: const TextStyle(
                                              fontSize: 12,
                                              color: Color(0xff666666)),
                                          textAlign: TextAlign.left))
                                ])),
                            Container(
                                margin: const EdgeInsets.only(top: 10),
                                child: Row(children: [
                                  const Text('编        码：',
                                      style: TextStyle(
                                          fontSize: 12,
                                          color: Color(0xff666666)),
                                      textAlign: TextAlign.left),
                                  Container(width: 10),
                                  Text(
                                      equipCode.indexOf("#") > 0
                                          ? equipCode.substring(3)
                                          : equipCode,
                                      style: const TextStyle(
                                          fontSize: 12,
                                          color: Color(0xff666666)),
                                      textAlign: TextAlign.left),
                                  Container(width: 10),
                                  Image.asset('assets/images/no_data.png',
                                      width: 12, height: 12)

                                  // assets/images/ewm.png
                                ]))
                          ])),
                      const Padding(
                          padding: EdgeInsets.all(15.0),
                          child: Icon(Icons.arrow_forward_ios_outlined,
                              color: Colors.blue, size: 16))
                    ])))
            //设备名称编号
          ])),
      Container(
          margin: const EdgeInsets.only(top: 20),
          //基本信息列表
          child: ListView.builder(
              physics: const NeverScrollableScrollPhysics(),
              key: const PageStorageKey('data'),
              itemCount: basicList.length,
              shrinkWrap: true,
              itemBuilder: (BuildContext context, int index) =>
                  ListEquipView(index, basicList[index])))
    ]));
  }
}

class ListEquipView extends StatelessWidget {
  int row;
  dynamic bean;

  ListEquipView(this.row, this.bean, {Key key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      alignment: Alignment.centerLeft,

      //单双行con颜色
      color: row % 2 == 0 ? Colors.white : Color(0xffefeff4),
      child: row == 0
          ? getCoulTextView()
          : row == 4
              ? getCoulTextView()
              : getTextView(),
    );
  }

  //row=0|4返回文字view
  getCoulTextView() {
    return Container(
        //padding: EdgeInsets.all(5),
        //padding:row==4?EdgeInsets.only(top: 30):EdgeInsets.only(top: 10),
        child: Column(
      children: <Widget>[
        Container(color: const Color(0xfff5f5f5), height: row == 4 ? 50 : 0),
        Container(
            alignment: Alignment.centerLeft,
            height: 30,
            padding: const EdgeInsets.all(5),
            color: const Color(0xff00ccff),
            child: Text(row == 4 ? '基本信息' : '入库信息',
                style: const TextStyle(fontSize: 12, color: Color(0xff333333)),
                textAlign: TextAlign.left)),
        Container(
            height: 40,
            padding: const EdgeInsets.all(5),
            child: Row(children: <Widget>[
              Container(
                  width: 70,
                  // color: Colors.red,
                  child: Text(bean['name'] + ' :  ',
                      style: const TextStyle(
                          fontSize: 12, color: Color(0xff666666)),
                      textAlign: TextAlign.left)),
              Text(bean['title'],
                  style:
                      const TextStyle(fontSize: 12, color: Color(0xff333333)),
                  textAlign: TextAlign.left)
            ]))
      ],
    ));
  }

  //返回文字view
  getTextView() {
    return Container(
        height: 40,
        padding: const EdgeInsets.all(5),
        child: Row(children: <Widget>[
          Container(
              width: 110,
              //color: Colors.red,
              child: Text(bean['name'] + ' :  ',
                  style:
                      const TextStyle(fontSize: 12, color: Color(0xff666666)),
                  textAlign: TextAlign.left)),
          Text(bean['title'],
              style: const TextStyle(fontSize: 12, color: Color(0xff333333)),
              textAlign: TextAlign.left)
        ]));
  }
}
