import 'package:amos_iot_login_tpl/amos_iot_login_tpl.dart';

mixin HttpConfig {
  static String _baseURL;
  static String _updateApkURL;

  static const int timeout = 40000;

  // 分页数量
  static const int pageSize = 20;

  // 请求延迟时间
  static const delayTime = 3;

  // 获取baseUrl
  static Future<String> getBaseUrl() async {
    if (_baseURL == null) {
      String url = await APIUrlManager.getGatewayUrl();
      _baseURL = url;
    }
    return _baseURL;
  }

  static Future<String> getUpdateApkUrl() async {
    if (_updateApkURL == null) {
      String url = await APIUrlManager.getUpdateApkUrl();
      _updateApkURL = url;
    }
    return _updateApkURL;
  }

  // 清除内存缓存的url
  // 更改服务地址后需要调用此方法清除
  static void clearMemoryCacheUrl() {
    _baseURL = null;
    _updateApkURL = null;
  }
}
