import 'package:flutter/material.dart';

class WarehouseTreePositionViewModel extends ChangeNotifier {
  // 位置树数组
  List _positions = [];

  List get positions => _positions;

  set positions(List value) {
    _positions=[];
    _positions = value;
    notifyListeners();
  }

  // 单位树
  List _department = [];

  List get department => _department;

  set department(List value) {
    value.forEach((item) {
      item['id'] = item['bizOrgCode'];
      if(item['children']!=null){
        item['children'] = processingData(item['children'],item['bizOrgCode']);
      }
    });

   _department = value;
    notifyListeners();
  }
}

processingData(List value,String parentId){
  value.forEach((item) {
    item['id'] = item['bizOrgCode'];
    item['parentId'] = parentId;
    if(item['children']!=null){
      processingData(item['children'],item['bizOrgCode']);
    }
  });
  return value;
}