import 'package:fluro/fluro.dart';
import 'package:flutter/material.dart';

mixin Application {
  static FluroRouter router;

  // 默认原生动画模式弹出页面
  static Future navigateTo(BuildContext context, String path,
      {bool clearStack = false}) {
    return router.navigateTo(context, path,
        transition: TransitionType.native, clearStack: clearStack);
  }

  // 支持传参
  static Future navigateToPath(BuildContext context, String path,
      {Map<String, dynamic> params,
      TransitionType transition = TransitionType.native,
      bool clearStack = false}) {
    String query = "";
    if (params != null) {
      int index = 0;
      for (var key in params.keys) {
        var value = Uri.encodeComponent(params[key]);
        if (index == 0) {
          query = "?";
        } else {
          query = query + "\&";
        }
        query += "$key=$value";
        index++;
      }
    }
    path = path + query;
    print(path);
    return router.navigateTo(context, path,
        transition: transition, clearStack: clearStack);
  }

  // 回到登陆页面
  static goToLogin() {}
}
