class RegExpUtils {
  static bool isIpAndPort(String input) {
    if (input == null || input.isEmpty) {
      return false;
    }
    return RegExp(
            r'^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\:([0-9]|[1-9]\d{1,3}|[1-5]\d{4}|6[0-5]{2}[0-3][0-5])$')
        .hasMatch(input);
  }

  static bool isValidUrl(String input) {
    if (input == null || input.isEmpty) {
      return false;
    }
    return RegExp(
            r'((http|ftp|https)://)(([a-zA-Z0-9\._-]+\.[a-zA-Z]{2,6})|([0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}))(:[0-9]{1,4})*(/[a-zA-Z0-9\&%_\./-~-]*)?')
        .hasMatch(input);
  }
}
