import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import '../../consts/color.dart';
import '../../utils/GetConfig.dart';
import '../../utils/app_theme.dart';
import '../../widgets/back_button.dart';

// 选择具体公司部门角色详情列表

class SelectRoleList extends StatelessWidget {
  final List roles;
  final String title;

  SelectRoleList(this.roles, this.title);

  @override
  Widget build(BuildContext context) {
    return SelectRoleListContent(roles, title);
  }
}

class SelectRoleListContent extends StatefulWidget {
  final List roles;
  final String title;

  SelectRoleListContent(this.roles, this.title);

  @override
  _SelectRoleListContentState createState() => _SelectRoleListContentState();
}

class _SelectRoleListContentState extends State<SelectRoleListContent> {
  int _index;
  String theme = '';

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    initThemeConfig();
  }

  initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme =
            preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        backgroundColor: AppTheme.backgroundColor,
        appBar: AppBar(
          title: Text(
            widget.title,
            style: TextStyle(color: Colors.black),
          ),
          leading: LeadingButton(theme: this.theme),
          centerTitle: true,
          backgroundColor: Colors.white,
        ),
        body: Stack(
          children: <Widget>[
            Padding(
              padding: EdgeInsets.only(bottom: _index == null ? 0 : 50.px),
              child: ListView.builder(
                  itemCount: widget.roles.length,
                  shrinkWrap: true,
                  itemBuilder: (ctx, index) {
                    final item = widget.roles[index];
                    String title;
                    if (item["companyName"] != null) {
                      title = item["companyName"];
                    } else if (item["departmentName"] != null) {
                      title = item["departmentName"];
                    } else {
                      title = item["roleName"];
                    }

                    return InkWell(
                      onTap: () {
                        setState(() {
                          _index = index;
                        });
                      },
                      child: Container(
                        color: Colors.white,
                        padding:
                            EdgeInsets.fromLTRB(24.px, 13.px, 24.px, 13.px),
                        child: Text("$title",
                            style:
                                Theme.of(context).textTheme.headline2.copyWith(
                                      color: index == _index
                                          ? GetConfig.getColor(theme)
                                          : Color(0xFF333333),
                                    )),
                      ),
                    );
                  }),
            ),
            _index == null ? Container() : buildBottomButton(context)
          ],
        ));
  }

  Widget buildBottomButton(context) {
    return Align(
      alignment: Alignment.bottomCenter,
      child: Container(
        height: 50.px,
        width: double.infinity,
        child: RaisedButton(
          color: GetConfig.getColor(theme),
          child: Text("确定", style: Theme.of(context).textTheme.headline2),
          onPressed: () => confirm(context),
        ),
      ),
    );
  }

  // 确定
  void confirm(BuildContext context) {
    Navigator.of(context).pop(widget.roles[_index]);
  }
}
