import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import '../../../consts/color.dart';
import '../../../consts/share_prefers_key_const.dart';
import '../../../model/CompanyInfo.dart';
import '../../../model/ContactInfo.dart';
import '../../../utils/GetConfig.dart';
import 'contact_item.dart';

class ContactExapandPage extends StatefulWidget {
  final ContractInfo item;

  ContactExapandPage(this.item);

  @override
  _ContactExapandPageState createState() => _ContactExapandPageState();
}

class _ContactExapandPageState extends State<ContactExapandPage> {
  final TextEditingController _controller = new TextEditingController();
  List<ChildInfo> tmpItem = List();
  List<ChildInfo> pageData = List();
  String theme = "";
  CompanyInfos company;

  @override
  void initState() {
    super.initState();

    setState(() {
      tmpItem = this.widget.item.children;
      pageData = this.widget.item.children;
    });
    initConfig();
  }

  initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme =
            preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
        company = CompanyInfos.fromJson(
            json.decode(preferences.get(SharePrefersKey.companyModelKey)));
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        backgroundColor: Color.fromRGBO(242, 246, 249, 1),
        appBar: AppBar(
          elevation: 0.2,
          brightness: Brightness.light,
          backgroundColor: KColorConstant.topBarColor,
          leading: new Container(
            child: GestureDetector(
              onTap: () => Navigator.pop(context),
              child: Icon(Icons.keyboard_arrow_left,
                  color: GetConfig.getColor(theme), size: 32),
            ),
          ),
          title: new Container(
            height: 30,
            width: 250,
            padding: EdgeInsets.only(bottom: 5),
            decoration: new BoxDecoration(
              color: Colors.grey[100],
              borderRadius: new BorderRadius.all(Radius.circular(25.0)),
            ),
            child: Row(
              children: <Widget>[
                Container(
                  padding: EdgeInsets.only(left: 5, right: 5, top: 6),
                  child: Image.asset("assets/images/search_red.png",
                      width: 20, color: GetConfig.getColor(theme)),
                ),
                new Container(
//                  child:Align(
                  width: MediaQuery.of(context).size.width - 180,
                  child: TextField(
                      controller: _controller,
//                  autofocus: true,
//                      focusNode: _focusNode,
                      style: TextStyle(fontSize: 16.0, color: Colors.black),
                      decoration: new InputDecoration(
                          border: InputBorder.none,
                          contentPadding: EdgeInsets.only(top: -15))),
//                  )
                )
              ],
            ),
          ),

//          new Container(
//            height: 40,
//            width: 350,
//            //padding: EdgeInsets.only(bottom: 15.0),
//            //margin: EdgeInsets.only(bottom: 5.0),
//            decoration: new BoxDecoration(
//              color: Colors.grey[100],
//              borderRadius: new BorderRadius.all(Radius.circular(30.0)),
//            ),
//            //child: new Container(
//            //margin: EdgeInsets.only(bottom: 15.0),
////                  child:Align(
//            //padding: EdgeInsets.only(bottom: 5.0),
//
//            child: Row(
//              children: <Widget>[
//                Container(
//                  padding: EdgeInsets.only(left: 5,right: 5,top:8),
//                  child: Image.asset("assets/images/search_"+theme+".png",width: 20,color: Colors.black26),
//                ),
//                Container(
//                  width: 190,
//                  child: TextField(
//                      controller: _controller,
//                      autofocus: false,
//                      style: TextStyle(fontSize: 15.0, color: Colors.black),
//                      decoration: new InputDecoration(
////                    prefixIcon: new Icon(
////                      Icons.search,
////                      color: Colors.black26,
////                    ),
//                        /*suffixIcon: GestureDetector(
//                            onTap: () => _controller.text = "",
//                            child: new Icon(
//                              Icons.delete_forever,
//                              color: Colors.black26,
//                            )),*/
//                          border: InputBorder.none,
//                          hintText: "请输入搜索内容")),
//                )
//              ],
//            )
//
////                  )
//            //)
//          ),
          centerTitle: true,
          actions: <Widget>[
            Align(
                child: Padding(
              padding: EdgeInsets.only(right: 8),
              child: GestureDetector(
                onTap: () {
                  setState(() {
                    if (this._controller.text.isEmpty) {
                      print(tmpItem.length);
                      pageData = tmpItem;
                    } else {
                      pageData = [];
                      tmpItem.forEach((f) {
                        if (f.label.indexOf(this._controller.text) != -1) {
                          pageData.add(f);
                        }
                      });
                    }
                  });
                },
                child: Text(
                  "搜索",
                  style: TextStyle(
                      color: GetConfig.getColor(theme), fontSize: 18.0),
                ),
              ),
            ))
          ],
        ),
        body: SingleChildScrollView(
          child: new Column(children: <Widget>[
            // Container(
            //   padding: EdgeInsets.only(left: 15.0),
            //   height: 30.0,
            //   color: Colors.white,
            //   child: new Row(
            //     children: <Widget>[
            //       TouchCallBack(
            //         child: Text(
            //           company== null?"": company.companyName+"/",
            //           style: TextStyle(color: GetConfig.getColor(theme)),
            //         ),
            //         onPressed: () {
            //           Navigator.pop(context);
            //         },
            //       ),
            //       Text(this.widget.item.name),
            //     ],
            //   ),
            // ),
            // Padding(
            //   padding: const EdgeInsets.only(left: 15.0, right: 15.0),
            //   child: Divider(
            //     height: 0.5,
            //     color: Colors.grey,
            //   ),
            // ),
            ListView.builder(
                physics: const NeverScrollableScrollPhysics(),
                itemCount: pageData.length,
                shrinkWrap: true,
                itemBuilder: (BuildContext context, int i) {
                  return Container(
                    color: Colors.white,
                    alignment: Alignment.centerLeft,
                    child: ContactItem(contexts: context, item: pageData[i]),
                  );
                }),
          ]),
        ));
  }
}
