import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import '../../consts/http_config.dart';
import '../../model/warehouse_info_view_model.dart';
import '../../utils/request.dart';
import 'pie_chart.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'dart:convert';



// 灭火药剂统计

class FireAgentStatisticCard extends StatefulWidget {
  @override
  _FireAgentStatisticCardState createState() => _FireAgentStatisticCardState();
}

class _FireAgentStatisticCardState extends State<FireAgentStatisticCard> {
  List<String> labels = [];
  List<Map<String, dynamic>> values = [];
  bool hasError = false;

  @override
  void initState() {
    super.initState();
    Future.delayed(Duration(seconds: HttpConfig.delayTime), () {
      String warehouseId =
          Provider
              .of<WarehouseInfoViewModel>(this.context, listen: false)
              .warehouseInfoModel
              ?.warehouse
              ?.id;
      if (warehouseId == null) return;
      HttpRequest.queryExtinguishingCategory(warehouseId).then((res) {
        if (res["status"] == 200) {
          Map<String, dynamic> result = res["result"];
          List<String> results1 = [];
          List<Map<String, dynamic>> results2 = [];
          double a = double.parse(result["S"]);
          double b = double.parse(result["QT"]);
          double c = double.parse(result["PM"]);
          double d = double.parse(result["GF"]);
          double total = a + b + c + d;
          if (result["S"] != null) {
            results1.add("水灭火剂");
            String value = (a / total * 100).toStringAsFixed(0);
            results2.add({"title": "$value%", "value": value});
          }
          if (result["QT"] != null) {
            results1.add("气体灭火剂");
            String value = (b / total * 100).toStringAsFixed(0);
            results2.add({"title": "$value%", "value": value});
          }
          if (result["PM"] != null) {
            results1.add("泡沫灭火剂");
            String value = (c / total * 100).toStringAsFixed(0);
            results2.add({"title": "$value%", "value": value});
          }
          if (result["GF"] != null) {
            results1.add("干粉灭火剂");
            String value = (d / total * 100).toStringAsFixed(0);
            results2.add({"title": "$value%", "value": value});
          }

          setState(() {
            labels = results1;
            values = results2;
          });
        }
      }).catchError((err) {
        if (!mounted) return;
        setState(() {
          hasError = true;
        });
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    if (hasError) {
      return Container(
          height: 150.px,
          child: Center(
            child: Text("请求数据失败"),
          ));
    } else if (labels.length == 0) {
      return Container(
          height: 150.px,
          child: Center(
            child: CupertinoActivityIndicator(),
          ));
    } else {
      return Padding(
          padding: EdgeInsets.only(left: 8.px, right: 8.px, top: 3.px),
          child: Card(
            shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.circular(6.px)),
            shadowColor: Color.fromRGBO(69, 91, 99, 0.08),
            elevation: 4,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Padding(
                    padding: EdgeInsets.only(left: 18.px, top: 9.px),
                    child: Text(
                      "灭火药剂按类别",
                      style: Theme.of(context).textTheme.headline4,
                    )),
                PieChartContent(
                  labels: labels,
                  values: values,
                )
              ],
            ),
          ));
    }
  }
}
