import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import '../../consts/color.dart';
import '../../utils/GetConfig.dart';
import '../../utils/request.dart';

// 区域抽屉
class StandardDrawer extends StatefulWidget {
  final String type;
  final ValueChanged<String> confirm;
  final Function reset;

  StandardDrawer({this.type, this.confirm, this.reset});

  @override
  _RegionDrawerState createState() => _RegionDrawerState();
}

class _RegionDrawerState extends State<StandardDrawer> {
  List<String> data = [];
  bool isEmpty = false;

  @override
  void initState() {
    super.initState();

    HttpRequest.getStandardList().then((res) {
      if (res["status"] == 200) {
        List result = res["result"];
        List<String> items = [];
        for (var json in result) {
          items.add(json);
        }
        setState(() {
          data = items;
        });
        if (items.length == 0) {
          setState(() {
            isEmpty = true;
          });
        }
      }
    }).catchError((err) {});
    initThemeConfig();
  }

  String theme = '';

  initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme =
            preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    if (isEmpty) {
      return Container(
        color: Colors.white,
        width: 300.px,
        child: SafeArea(
            child: Center(
          child: Text("请求数据为空"),
        )),
      );
    } else if (data.length == 0) {
      return Container(
        color: Colors.white,
        width: 300.px,
        child: SafeArea(
            child: Center(
          child: CupertinoActivityIndicator(),
        )),
      );
    } else {
      return Container(
        color: Colors.white,
        width: 300.px,
        child: SafeArea(
          child: Column(
            children: <Widget>[
              Padding(
                padding: EdgeInsets.only(top: 12.px),
                child: Text(
                  "规格",
                  style: Theme.of(context)
                      .textTheme
                      .headline4
                      .copyWith(color: Color(0xFF333333)),
                ),
              ),
              Expanded(
                child: ListView.builder(
                    itemCount: data.length,
                    itemBuilder: (ctx, index) {
                      String title = data[index];
                      return InkWell(
                          onTap: () {
                            Navigator.of(context).pop();
                            if (widget.confirm != null) {
                              widget.confirm(title);
                            }
                          },
                          child: ListTile(
                            title: Text(
                              "$title",
                              style: Theme.of(context).textTheme.headline6,
                            ),
                          ));
                    }),
              ),
              Container(
                height: 40.px,
                width: double.infinity,
                child: RaisedButton(
                  shape: BeveledRectangleBorder(),
                  color: GetConfig.getColor(theme),
                  child: Text(
                    "重置",
                    style: Theme.of(context).textTheme.headline2,
                  ),
                  onPressed: () {
                    Navigator.of(context).pop();
                    if (widget.reset != null) {
                      widget.reset();
                    }
                  },
                ),
              )
            ],
          ),
        ),
      );
    }
  }
}
