import 'dart:ui';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import '../consts/toast_message.dart';
import '../utils/GetConfig.dart';

import '../utils/flutter_toast.dart';

class PinTextDialog extends Dialog {
  final Function(String value) callback;
  final Function cancel;
  final String theme;

  PinTextDialog({Key key, this.callback, this.cancel, this.theme}) : super(key: key);

  TextEditingController controller = TextEditingController();

  @override
  Widget build(BuildContext context) {
    return Material(
      //创建透明层
      type: MaterialType.transparency, //透明类型
      child: BackdropFilter(
        filter: ImageFilter.blur(sigmaX: 10.0, sigmaY: 10.0),
        child: Container(
          child: Center(
            child: Container(
              decoration: ShapeDecoration(
                  color: Colors.white, shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(10.px))),
              width: MediaQuery.of(context).size.width - 40.px,
              child: Column(
                mainAxisSize: MainAxisSize.min,
                children: <Widget>[buildTopBar(context), buildTextField(context), buildButton(context)],
              ),
            ),
          ),
        ),
      ),
    );
  }

  // 头部
  Widget buildTopBar(context) {
    return Container(
      height: 44.px,
      child: Stack(children: [
        Container(
          padding: EdgeInsets.symmetric(vertical: 10.px),
          decoration: ShapeDecoration(
              color: const Color(0xFFefeff4),
              shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.only(topLeft: Radius.circular(5.px), topRight: Radius.circular(5.px)))),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: const <Widget>[
              Text(
                '输入编码查询',
              )
            ],
          ),
        ),
        Align(
            alignment: Alignment.centerRight,
            child: Container(
              padding: const EdgeInsets.only(right: 10),
              child: IconButton(
                icon: const Icon(
                  Icons.clear,
                  size: 20,
                ),
                onPressed: () {
                  Navigator.of(context).pop();
                  if (cancel != null) {
                    cancel();
                  }
                },
              ),
            ))
      ]),
    );
  }

  // 输入框
  Widget buildTextField(context) {
    return Padding(
      padding: EdgeInsets.symmetric(horizontal: 20.px),
      child: TextField(
        autofocus: true,
        decoration: const InputDecoration(border: InputBorder.none),
        keyboardType: TextInputType.number,
        controller: controller,
        inputFormatters: [LengthLimitingTextInputFormatter(20), WhitelistingTextInputFormatter.digitsOnly],
      ),
    );
  }

  // 按钮
  Widget buildButton(context) {
    return Container(
      padding: EdgeInsets.only(top: 10.px),
      width: MediaQuery.of(context).size.width,
      height: 50.px,
      child: RaisedButton(
        color: Theme.of(context).primaryColor,
        child: const Text(
          '下一步',
          style: TextStyle(color: Colors.white),
        ),
        onPressed: () {
          String value = controller.text;
          if (value.isEmpty) {
            FlutterToast.toastCenter(ToastMessage.pinTextNone);
            return;
          } else if (value.length < 13) {
            FlutterToast.toastCenter(ToastMessage.pinTextNotLength);
            return;
          } else {
            Navigator.of(context).pop();
            if (callback != null) {
              callback(controller.text);
            }
          }
        },
      ),
    );
  }
}
