import 'package:base/services/application.dart';
import 'package:fluro/fluro.dart';

import 'route_handler.dart';

mixin Routes {
  ///装备管理页面
  static String equipmentInfo = '/equipmentInfo';
  static String equipCarExtinguishDetail = '/equipCarExtinguishDetail';
  static String equipWareHousing = '/equipWareHousing';
  static String createScrap = '/createScrap';
  static String categoryDetailList = '/categoryDetailList';
  static String equipCarExtinguishList = '/equipCarExtinguishList';
  static String vehicleLoaded = '/vehicleLoaded';
  static String vehicleResume = '/vehicleResume';
  static String vehicleManufacturingEnterprise = '/vehicleManufacturingEnterprise';
  static String submitSuccess = '/submitSuccess';
  static String commonSearchList = '/commonSearchList';
  static String commonSingleEquipmentList = '/commonSingleEquipmentList';
  static String equipmentAddList = '/equipmentAddList';
  static String commonAddFireAgent = '/commonAddFireAgent';
  static String addFireAgentConfirm = '/addFireAgentConfirm';
  static String scrapPostBill = '/scrapPostBill';
  static String fireAgentInStock = '/fireAgentInStock';
  static String vehicleInfo = '/vehicleInfo';
  static String equipmentSecondInfo = '/equipmentSecondInfo';
  static String vehicleHomePage = '/vehicleHomePage';

  static void configureRoutes(FluroRouter router) {
    Application.router = router;
    router.define(equipmentInfo, handler: equipmentInfoHandler);
    router.define(equipCarExtinguishDetail, handler: equipmentDetailHandler);

    router.define(equipWareHousing, handler: equipWareHousingHandler);
    router.define(createScrap, handler: createScrapHandler);

    router.define(categoryDetailList, handler: categoryDetailListHandler);
    router.define(equipCarExtinguishList, handler: equipCarExtinguishListHandler);
    router.define(vehicleLoaded, handler: vehicleLoadedConfigHandler);
    router.define(vehicleResume, handler: vehicleResumeHandler);
    router.define(vehicleManufacturingEnterprise, handler: vehicleManufacturingEnterpriseHandler);
    router.define(submitSuccess, handler: submitSuccessHandler);
    router.define(commonSearchList, handler: commonSearchListHandler);
    router.define(commonSingleEquipmentList, handler: commonSingleEquipmentListHandler);
    router.define(equipmentAddList, handler: equipmentAddListHandler);
    router.define(commonAddFireAgent, handler: commonAddFireAgentHandler);
    router.define(addFireAgentConfirm, handler: addFireAgentConfirmHandler);
    router.define(scrapPostBill, handler: scrapPostBillHandler);
    router.define(fireAgentInStock, handler: fireAgentInStockHandler);
    router.define(vehicleInfo, handler: vehicleInfoHandler);
    router.define(equipmentSecondInfo, handler: equipmentSecondInfoHandler);
    router.define(vehicleHomePage, handler: vehicleHomePageHandler);
  }
}
