import 'package:base/consts/color.dart';
import 'package:flutter/material.dart';

import 'package:shared_preferences/shared_preferences.dart';

import 'package:base/widgets/back_button.dart';

GlobalKey<_VehicleLoadedContentState> childKey = GlobalKey();

class VehicleLoaded extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(
          "装载器材",
          style: TextStyle(color: Colors.black),
        ),
        centerTitle: true,
        leading: LeadingButton(
          theme: childKey.currentState.theme,
        ),
      ),
      body: VehicleLoadedContent(),
    );
  }
}

class VehicleLoadedContent extends StatefulWidget {
  @override
  _VehicleLoadedContentState createState() => _VehicleLoadedContentState();
}

class _VehicleLoadedContentState extends State<VehicleLoadedContent> {
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    initThemeConfig();
  }

  String theme = '';
  initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme =
            preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Container();
  }
}
