import 'dart:convert';

import 'package:base/model/route_model.dart';
import 'package:fluro/fluro.dart';
import 'package:flutter/material.dart';

import '../view/add_fireagent_confirm.dart';
import '../view/common_add_fire_agent.dart';
import '../view/create_scrap.dart';
import '../view/equipment_add_list.dart';
import '../view/fire_agent_in_stock.dart';
import '../view/offlinemode_equip_warehousing.dart';
import '../view/scrap_post_bill.dart';
import '../view/submit_sucess.dart';

///---------------离线模式-------------------
Handler offlineEquipWareHousingHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
      category: params["category"]?.first,
      title: params["title"]?.first,
      item: params["item"]?.first);
  return OfflineEquipWareHousing(
    routeModel: model,
  );
});
Handler OfflineEquipmentAddListHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
      category: params["category"]?.first,
      title: params["title"]?.first,
      item: params["item"]?.first,
      extension: params["extension"] != null
          ? json.decode(params["extension"]?.first)
          : {});
  return OfflineEquipmentAddList(
    routeModel: model,
  );
});
Handler offlineFireAgentInStockHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
      category: params["category"]?.first,
      title: params["title"]?.first,
      item: params["item"]?.first,
      extension: params["extension"] != null
          ? json.decode(params["extension"]?.first)
          : {});
  return OfflineFireAgentInStock(
    routeModel: model,
  );
});
Handler offlineAddFireAgentConfirmHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
      category: params["category"]?.first,
      title: params["title"]?.first,
      item: params["item"]?.first,
      extension: json.decode(params["extension"]?.first));
  return OfflineAddFireAgentConfirm(
    routeModel: model,
  );
});

Handler offlineScrapPostBillHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
      category: params["category"]?.first,
      title: params["title"]?.first,
      item: params["item"]?.first,
      extension: params["extension"] != null
          ? json.decode(params["extension"]?.first)
          : {});
  return OfflineScrapPostBill(
    routeModel: model,
  );
});
Handler offlineSubmitSuccessHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
    category: params["category"]?.first,
    title: params["title"]?.first,
    item: params["item"]?.first,
    //   extension: json.decode(params["extension"]?.first)
  );
  return OfflineSubmitSuccess(
    routeModel: model,
  );
});
Handler offlineCommonAddFireAgentHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
      category: params["category"]?.first,
      title: params["title"]?.first,
      item: params["item"]?.first,
      extension: params["extension"] != null
          ? json.decode(params["extension"]?.first)
          : {});
  return OfflineCommonAddFireAgent(
    routeModel: model,
  );
});
Handler offlineCreateScrapHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
      category: params["category"]?.first,
      title: params["title"]?.first,
      item: params["item"]?.first);
  return OfflineCreateScrap(routeModel: model);
});
