import 'package:fluro/fluro.dart';

import 'route_handler.dart';

mixin Routes {
  ///日常巡检
  static String planPatrol = '/PlanPatrol';
  static String noPlanPatrol = '/NoPlanPatrol';
  static String moblePatrol = '/MoblePatrol';
  static String patrolLog = '/PatrolLog';
  static String patrolLogDetails = '/PatrolLogDetails';
  static String patrolPoint = '/PatrolPoint';
  static String patrolCalendar = '/PatrolCalendar';
  static String patrolDetails = '/PatrolDetails';

  ///缺陷治理
  static String myReceive = '/MyReceive';
  static String mySend = '/MySend';
  static String addTask = '/AddTask';
  static String allTask = '/AllTask';

  ///隐患治理
  static String waitHandlePage = '/waitHandle';
  static String haveHandlePage = '/haveHandle';
  static String latentDangerSavePage = '/latentDangerSave';
  static String latentDangerDetailsPage = '/latentDangerApp'; // 消息巡检隐患跳转页面路由

  static void configureRoutes(FluroRouter router) {
    ///日常巡检
    router.define(planPatrol, handler: planPatrolHandler); //计划巡检
    router.define(noPlanPatrol, handler: noPlanPatrolHandler); //无计划巡检
    router.define(moblePatrol, handler: moblePatrolHandler); //移动巡检
    router.define(patrolLog, handler: patrolLogHandler); //巡检记录
    router.define(patrolPoint, handler: patrolPointHandler); //巡检点
    router.define(patrolCalendar, handler: patrolCalendarHandler); //巡检日历

    ///缺陷治理
    router.define(myReceive, handler: myReceiveHandler); //我接收
    router.define(mySend, handler: mySendHandler); //我发起
    router.define(addTask, handler: addTaskHandler); //任务添加
    router.define(allTask, handler: allTaskHandler); //全部任务

    ///隐患治理
    router.define(waitHandlePage, handler: pendingHideHandler); //待处理
    router.define(haveHandlePage, handler: processedHiddenHandler); //已处理
    router.define(latentDangerSavePage, handler: hiddenDangerHandler); //隐患添加
  }
}
