import 'package:base/services/api_address.dart';
import 'package:base/utils/HttpUtil.dart';

import '../model/ExtClass.dart';

//获取全部扩展分类列表
Future<List<ExtClass>> queryCatalogList() async {
  try {
    // 根据输入参数拼接请求body

    List<ExtClass> result = new List();
    var data = await HttpUtil().get(ApiAddress.QUERY_CATALOG_LIST);
    //具体实现函数待编写
    if (data["result"] == "SUCCESS") {
      var dataList = data["dataList"];
      for (var _dataList in dataList) {
        result.add(ExtClass.fromJson(_dataList));
      }
    }
    return result;
  } catch (e) {
    print(e);
    return new List();
  }
}

class extBean {
  int id;
  String title;

  static extBean fromMap(Map<String, dynamic> map) {
    if (map == null) return null;
    extBean extBeanBean = extBean();
    extBeanBean.id = map['id'];
    extBeanBean.title = map['title'];
    return extBeanBean;
  }

  Map toJson() => {
        "id": id,
        "title": title,
      };
}
