import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:base/consts/external_assets_package_key.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';

import '../../view/CheckExecute/checkexec_inspection.dart';
import '../../view/CheckExecute/checkexec_list_screen.dart';
import '../../view/CheckExecute/checkexec_spot_detail.dart';

class NavigationCheckExec extends StatefulWidget {
  final int pointId;
  final int planId;
  final String pointName;
  final String checkMode;

  const NavigationCheckExec(this.pointId, {this.planId, this.pointName, this.checkMode});

  @override
  State<StatefulWidget> createState() => _NavigationCheckExec();
}

class _NavigationCheckExec extends State<NavigationCheckExec> with SingleTickerProviderStateMixin {
  TabController _tabController;
  int _selectedIndex = 0;
  var titles = ['巡检', '记录', '详情'];
  String theme = 'blue';

  @override
  void initState() {
    super.initState();
    _tabController = TabController(vsync: this, initialIndex: 0, length: titles.length);
    _tabController.addListener(() {
      if (_tabController.indexIsChanging) {
        setState(() => _selectedIndex = _tabController.index);
      }
    });
  }


  @override
  Widget build(BuildContext context) {
    if (theme.isEmpty) {
      return const Scaffold(body: Text(''));
    }
    return Scaffold(
      bottomNavigationBar: Container(
        color: Colors.white,
        height: 60.0,
        child: Column(
          children: <Widget>[
            const Padding(
              padding: EdgeInsets.only(top: 5),
            ),
            TabBar(
              isScrollable: false,
              controller: _tabController,
              indicatorColor: Colors.white,
              labelColor: Colors.black,
              labelPadding: const EdgeInsets.all(0),
              unselectedLabelColor: Colors.white,
              tabs: <Widget>[
                EachTab(
                  width: 80,
                  height: 50,
                  padding: const EdgeInsets.all(0),
                  icon: _selectedIndex == 0
                      ? Image.asset(
                          'assets/images/checkexec/inspection_' + theme + '.png',
                          package: ExternalAssetsPackageKey.BASE,
                          width: 70,
                          height: 22,
                        )
                      : Image.asset(
                          'assets/images/checkexec/un_inspection.png',
                          package: ExternalAssetsPackageKey.BASE,
                          width: 70,
                          height: 22,
                        ),
                  text: titles[0],
                  iconPadding: const EdgeInsets.fromLTRB(0, 0, 0, 10),
                  textStyle:
                      TextStyle(fontSize: 12, color: _selectedIndex == 0 ? GetConfig.getColor(theme) : Colors.grey),
                ),
                EachTab(
                  width: 80,
                  height: 50,
                  padding: const EdgeInsets.all(0),
                  icon: _selectedIndex == 1
                      ? Image.asset(
                          'assets/images/checkexec/record_' + theme + '.png',
                          package: ExternalAssetsPackageKey.BASE,
                          width: 70,
                          height: 22,
                        )
                      : Image.asset(
                          'assets/images/checkexec/un_record.png',
                          package: ExternalAssetsPackageKey.BASE,
                          width: 70,
                          height: 22,
                        ),
                  text: titles[1],
                  iconPadding: const EdgeInsets.fromLTRB(0, 0, 0, 10),
                  textStyle:
                      TextStyle(fontSize: 12, color: _selectedIndex == 1 ? GetConfig.getColor(theme) : Colors.grey),
                ),
                EachTab(
                  width: 80,
                  height: 50,
                  padding: const EdgeInsets.all(0),
                  icon: _selectedIndex == 2
                      ? Image.asset(
                          'assets/images/checkexec/detail_' + theme + '.png',
                          package: ExternalAssetsPackageKey.BASE,
                          width: 70,
                          height: 22,
                        )
                      : Image.asset(
                          'assets/images/checkexec/un_detail.png',
                          package: ExternalAssetsPackageKey.BASE,
                          width: 70,
                          height: 22,
                        ),
                  text: titles[2],
                  iconPadding: const EdgeInsets.fromLTRB(0, 0, 0, 10),
                  textStyle:
                      TextStyle(fontSize: 12, color: _selectedIndex == 2 ? GetConfig.getColor(theme) : Colors.grey),
                )
              ],
              onTap: (int idx) {
                _selectedIndex = idx;
              },
            )
          ],
        ),
      ),
      body: TabBarView(
        physics: const NeverScrollableScrollPhysics(), //设置滑动的效果，这个禁用滑动
        controller: _tabController,
        children: <Widget>[
          CheckExecInspection(widget.pointId, widget.planId, widget.checkMode),
          CheckExecListScreen(widget.pointId, widget.pointName),
          CheckExecSpotDetail(widget.pointId, false),
        ],
      ),
    );
  }
}
