import 'package:base/consts/color.dart';
import 'package:base/consts/external_assets_package_key.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/name_value.dart';
import '../../services/route_list_services.dart';

class SelectRouteCalendarPage extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => _SelectRouteCalendarPageState();
}

class _SelectRouteCalendarPageState extends State<SelectRouteCalendarPage> {
  final TextEditingController _controller = TextEditingController();
  final FocusNode _focusNode = FocusNode();
  List<NameValue> routeList = [];
  List<NameValue> tmpRouteList = [];
  String theme = '';

  @override
  void initState() {
    super.initState();
    getInitInfo();
    initConfig();
  }

  @override
  Widget build(BuildContext context) {
    if (theme.isEmpty) {
      return const Scaffold(body: Text(''));
    }

    return Scaffold(
      backgroundColor: Colors.white,
      appBar: AppBar(
        elevation: 0.3,
        brightness: Brightness.light,
        title: Container(
          height: 30,
          width: MediaQuery.of(context).size.width - 130,
          padding: const EdgeInsets.only(bottom: 5),
          decoration: BoxDecoration(
            color: Colors.grey[100],
            borderRadius: const BorderRadius.all(Radius.circular(25.0)),
          ),
          child: Row(
            children: <Widget>[
              Container(
                padding: const EdgeInsets.only(left: 5, right: 5, top: 6),
                child: Icon(
                  Icons.search,
                  color: Theme.of(context).primaryColor,
                ),
              ),
              Container(
                width: MediaQuery.of(context).size.width - 180,
                child: TextField(
                    controller: _controller,
                    focusNode: _focusNode,
                    style: const TextStyle(fontSize: 16.0, color: Colors.black),
                    decoration:
                        const InputDecoration(border: InputBorder.none, contentPadding: EdgeInsets.only(top: -15))),
              )
            ],
          ),
        ),
        actions: <Widget>[
          Align(
              child: Padding(
            padding: const EdgeInsets.only(right: 8),
            child: GestureDetector(
              onTap: () {
                setState(() {
                  if (_controller.text.isEmpty) {
                    routeList = tmpRouteList;
                  } else {
                    routeList = tmpRouteList.where((f) => f.name.contains(_controller.text)).toList();
                  }
                });
              },
              child: const Text(
                '搜索',
                style: TextStyle(color: Colors.white, fontSize: 16.0),
              ),
            ),
          ))
        ],
      ),
      body: ListView.builder(
        itemCount: routeList.length,
        itemBuilder: (context, index) {
          return ListTile(
            title: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Text('${routeList[index].name}'),
                const Divider(
                  height: 1,
                )
              ],
            ),
            onTap: () {
              Navigator.pop(context, NameValue(routeList[index].name, routeList[index].value));
            },
          );
        },
      ),
    );
  }

  void getInitInfo() async {
    await getRouteList().then((data) {
      setState(() {
        NameValue d = NameValue('全部线路', -1);
        routeList = data;
        tmpRouteList = data;
        routeList.insert(0, d);
      });
    });
  }

  initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }
}
