import 'dart:async';

import 'package:base/consts/color.dart';
import 'package:base/consts/external_assets_package_key.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import 'package:flutter_nfc_tools/flutter_nfc_tools.dart';
import 'package:shared_preferences/shared_preferences.dart';

import './../../task_process/task_process_screen.dart';
import '../../../model/Task/TaskContentResult.dart';
import '../../../services/no_plan_inspection.dart';
import '../task_detail_screen.dart';

class NfcPage extends StatefulWidget {
  final TaskContent task;
  final String pointNo;

  NfcPage(this.task, this.pointNo);

  @override
  State<StatefulWidget> createState() => _NfcPageState();
}

class _NfcPageState extends State<NfcPage> {
//  NfcData _nfcData;
  String _platformVersion = 'Unknown';

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          title: Text(
            "NFC",
            style: TextStyle(color: Colors.black, fontSize: 19),
          ),
          centerTitle: true,
          elevation: 0.2,
          brightness: Brightness.light,
          backgroundColor: Colors.grey,
          leading: new Container(
            child: GestureDetector(
              onTap: () {
                Navigator.pop(context);
              },
              child: Icon(Icons.keyboard_arrow_left,
                  color: GetConfig.getColor(theme), size: 32),
            ),
          ),
        ),
        body: Container(
          color: Colors.black54,
          width: double.infinity,
          child: Container(
            padding: EdgeInsets.only(top: 30),
            child: Column(
              children: <Widget>[
                Container(
                  height: 40,
                  width: 200,
                  child: Align(
                    alignment: Alignment.center,
                    child: Text(
                      "靠近巡检标签",
                      style: TextStyle(fontSize: 16, color: Colors.white),
                    ),
                  ),
                  decoration: new BoxDecoration(
                    color: Colors.black38,
                    borderRadius: new BorderRadius.all(Radius.circular(25.0)),
                  ),
                ),
                const Padding(
                  padding: EdgeInsets.only(bottom: 20),
                ),
                Image.asset(
                  'assets/images/noplan/nfc_m.png',
                  package: ExternalAssetsPackageKey.BASE,
                  height: 200.0,
                  width: 270.0,
                )
              ],
            ),
          ),
        )
//      Container(
//        color: Colors.black54,
//        child:  Column(
//          children: <Widget>[
//            Expanded(
//              child: Stack(
//                children: <Widget>[
//                  Align(
//                    alignment: const Alignment(0, -1),
//                    child: Padding(padding: EdgeInsets.only(top: 50),
//                      child:Container(
//                        height: 40,
//                        width: 200,
//                        child:Align(
//                          alignment: Alignment.center,
//                          child: Text("靠近巡检标签",style: TextStyle(fontSize: 16,color: Colors.white),),
//                        ),
//                        decoration: new BoxDecoration(
//                          color: Colors.black38,
//                          borderRadius: new BorderRadius.all(Radius.circular(25.0)),
//                        ),
//                      ),
//                    ),
//                  ),
//                  Center(
//                    child: Stack(
//                      children: <Widget>[
//                        Padding(padding: EdgeInsets.only(bottom: 10),),
//                        SizedBox(
//                            height: 200.0,
//                            width: 270.0,
//                            child: Image.asset("assets/images/noplan/nfc_m.png",)
//                        ),
//                      ],
//                    ),
//                  ),
//                ],
//              ),
//              flex: 1,
//            )
//          ],
//        ),
//      )
        );
  }

  Future<void> initPlatformState() async {
    try {
      FlutterNfcTools.ndefEventsStream.listen((m) {
        if (m['ndefMessage'] == null) {
          shortMessage('标签无内容');
          return;
        }

        print(m['ndefMessage'][0]['payload']);

        List<int> payload =
            m['ndefMessage'][0]['payload'].sublist(3).cast<int>().toList();
        String content = FlutterNfcTools.bytesToString(payload);
        if (content.isNotEmpty) {
          getContent(content);
        } else {
          shortMessage('标签内容无法识别！');
        }
      });
    } on PlatformException {
      shortMessage('内容读取失败！');
    }

    if (!mounted) return;
  }

  @override
  void initState() {
    super.initState();
    initPlatformState();
    initThemeConfig();
  }

  String theme = '';

  initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme =
            preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  getContent(String no) async {
    await getQueryPlanTaskBySerialInfo(2, no, null).then((data) {
      // 跳转页面
      if (data != null && data.success) {
//        if(this.widget.taskId != null && this.widget.taskId>0){
//          Navigator.push( context,
//              new MaterialPageRoute(builder: (context) {
//                return NavigationCheckExec(data.id,planId: this.widget.taskId,);
//              }));
//        }else{
//          Navigator.push( context,
//              new MaterialPageRoute(builder: (context) {
//                return NavigationCheckExec(data.id);
//              }));
//        }
        if (this.widget.pointNo == no) {
          Navigator.push(
              context,
              new MaterialPageRoute(
                  builder: (context) => new TaskProcessPage(
                        task: widget.task,
                      ))).then((v) {
            Navigator.push(
                context,
                new MaterialPageRoute(
                    builder: (context) => new TaskDetailPage(
                          task: this.widget.task,
                        )));
          });
        } else {
          shortMessage('请扫描正确的标签！');
        }
      } else {
        shortMessage(data.message);
      }
    });
  }
}
