import 'package:amos_iot_login_tpl/amos_iot_login_tpl.dart';


// import 'package:base/routes/routes.dart' as base_routes;
import 'package:get/get_navigation/src/routes/get_route.dart';
import './../consts/iot_page_config.dart';
import '../view/scanOnce/NewQrPage.dart';
import '../view/sendForInspection/InspectionPage.dart';

mixin JCSRoutes {
  static const String root = '/';
  static const String index = '/index';
  // 计量业务
  static const String scanOnce = '/scanOnce'; //扫一扫
  static const String sendForInspection = '/sendForInspection'; //送检
  static const String receive = '/receive'; //接收
  static const String collect = '/collect'; //领取
  static const String equipdetails = '/equipdetails'; //设备详情


  static List<GetPage> getPages() {
    return [
      GetPage(name: root, page: () => Login(IotPageConfig.loginInfo)),

      /// 计量业务
      GetPage(name: scanOnce, page: () => const NewQrPage()),
      GetPage(name: sendForInspection, page: () =>  InspectionPage(bizType: 'submission')),
      GetPage(name: receive, page: () => InspectionPage(bizType: 'receive')),
      GetPage(name: collect, page: () => InspectionPage(bizType: 'recaption')),

    ];
  }
}
