import 'dart:io';

import 'package:jcs_airport/consts/url_const.dart';
import 'package:jcs_airport/utils/request.dart';

class API {

  ///------------------------------------------------AMOS平台---------------------------------------------------

  /// 根据计量编号获取设备详情
  static Future queryEquipDetailsByCode(String code) async {
    return await AmosHttp.client.get(URLConst.queryEquipDetailsByCode, query: { "equipmentCode": code });
  }

  /// 根据计量编号进行送检、接收、报废
  static Future scanEquipQrCodeBizCode(String code, String type) async {
    return await AmosHttp.client.get(URLConst.scanEquipQrCodeBiz + type + '/execute/app', query: { "equipmentCode": code });
  }
}
