import 'package:flutter/material.dart';
import 'package:jcs_airport/consts/colors.dart';
import 'package:shared_preferences/shared_preferences.dart';

class GetConfig {
  static Future<String> getTheme() async {
    var pref = await SharedPreferences.getInstance();
    return pref.getString('theme') == null || pref.getString('theme').isEmpty
        ? KColorConstant.DEFAULT_COLOR
        : pref.getString('theme').toString();
  }

  static Future getLogo() async {
    var pref = await SharedPreferences.getInstance();
    return pref.get('logo') ?? '';
  }

  static Future getThemeTimestamp() async {
    var pref = await SharedPreferences.getInstance();
    return pref.get('themeTimestamp') ?? '';
  }

  static Color getColor(String theme) {
    if (theme == 'red') {
      return const Color.fromRGBO(209, 6, 24, 1);
    } else if (theme == 'blue') {
      return const Color.fromRGBO(50, 89, 206, 1);
    } else {
      // 默认红色
      return const Color.fromRGBO(50, 89, 206, 1);
    }
  }
}
