
import 'package:flutter/material.dart';
import 'package:jcs_airport/services/api.dart';
import 'HomeMenuCard.dart';
import 'dart:async';




///@Description     非领导首页
///@author          helinlin
///@create          2021-11-17 13:42
class HomeCommon extends StatefulWidget {
  const HomeCommon({Key key}) : super(key: key);

  @override
  _HomeCommonState createState() => _HomeCommonState();
}

class _HomeCommonState extends State<HomeCommon> {
  Map amosUser = {
    'companys': [{}]
  };




  @override
  void initState() {
    super.initState();

    agencyuserMe();


  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('首页'),
        centerTitle: true,
      ),
      body: SingleChildScrollView(
        child: Container(
          color: const Color.fromARGB(255, 245, 250, 245),
          child: Stack(
            children: [
              Container(
                height: 300,
                decoration: const BoxDecoration(
                    gradient: LinearGradient(
                        begin: Alignment.topCenter, end: Alignment.bottomCenter, colors: [Colors.blue, Colors.blue])),
                child: Container(),
              ),
              Column(
                children: [
                  getPersonInfo(),
                  const HomeMenuCard()
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }

  Widget getPersonInfo() {
    var aa = amosUser['companys'];
    String companyId = '';
    var companiesList = amosUser["companys"];
    if (companiesList is List && companiesList.length > 0) {
      var companyItem = companiesList[0];
      if (companyItem is Map && companyItem.containsKey("sequenceNbr")) {
        companyId = companyItem["sequenceNbr"];
      }
    }
    String dptName = null;
    var companyDepartments = amosUser["companyDepartments"];
    if (companyDepartments is Map<String, dynamic> && companyDepartments != null) {
      var deptList  = companyDepartments[companyId];
      if (deptList is List && deptList.length > 0) {
        var deptItem = deptList[0];
        if (deptItem is Map && deptItem.containsKey("departmentName")) {
          dptName = deptItem["departmentName"];
        }
      }
    }
    return Padding(
      padding: const EdgeInsets.all(25.0),
      child: Row(
        children: [
          Expanded(
            child: Container(
              height: 170,
              decoration: const BoxDecoration(
                  color: Colors.blueAccent,
                  borderRadius: BorderRadius.all(Radius.circular(20)),
                  boxShadow: <BoxShadow>[
                    BoxShadow(offset: Offset(2, 2), blurRadius: 15, color: Colors.lightBlue),
                  ]),
              child: Padding(
                padding: const EdgeInsets.all(10.0),
                child: Stack(
                  children: [
                    Positioned(
                      left: 10,
                      top: 10,
                      child: Text(
                        '${amosUser['realName'] ?? ''}',
                        style: const TextStyle(color: Colors.white),
                      ),
                    ),
                    Positioned(
                      left: 10,
                      bottom: 10,
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text('${amosUser['mobile'] ?? ''}', style: const TextStyle(color: Colors.white, fontSize: 13)),
                          Text('${dptName ?? (amosUser['companys'][0] ?? [])['companyName'] ?? ''}',
                              style: const TextStyle(color: Colors.white, fontSize: 13)),
                        ],
                      ),
                    ),
                    Positioned(
                        right: 10,
                        top: 10,
                        child: Image.asset(
                                'assets/images/person_default.png',
                                height: 60,
                                fit: BoxFit.fill,
                              )
                           )
                  ],
                ),
              ),
            ),
          ),
        ],
      ),
    );
  }

  ///获取Amos用户详细信息
  Future<void> agencyuserMe() async {
    var result = await API.agencyuserMe();
    if (result == null) {
      return;
    }
    setState(() {
      amosUser.addAll(result);
    });

  }



}
