import 'package:amos_flutter_ui/common/card.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:jcs_airport/consts/styles.dart';

///@Description     树形选择
///@author          helinlin
///@create          2021-09-03 15:32
abstract class BaseTreeChoose extends StatefulWidget {
  Map chooseDepartment;

  BaseTreeChoose({this.chooseDepartment});

  @override
  BaseTreeChooseState createState() => getBaseBaseChooseDepartmentState();

  BaseTreeChooseState getBaseBaseChooseDepartmentState();
}

abstract class BaseTreeChooseState extends State<BaseTreeChoose> {
  final List departments = [];
  final GlobalKey<ScaffoldState> _scaffoldKey = GlobalKey<ScaffoldState>();
  String _idKey;
  String _nameKey;

  @override
  void initState() {
    super.initState();
    _idKey = getIdKey();
    _nameKey = getNameKey();
    getData();
  }

  @override
  void didChangeDependencies() {
    super.didChangeDependencies();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      resizeToAvoidBottomInset: false,
      key: _scaffoldKey,
      appBar: AppBar(
        title: const Text('请选择'),
      ),
      body: Column(
        children: [
          Expanded(
            child: departments.isNotEmpty ? buildListView(departments) : Container(),
          ),
          Container(
            padding: const EdgeInsets.all(10),
            child: Row(
              children: [
                Expanded(
                  child: FlatButton(
                    color: Theme.of(context).primaryColor,
                    height: 40,
                    onPressed: () {
                      Get.back(result: widget.chooseDepartment);
                    },
                    child: const Text(
                      '确定',
                      style: TextStyle(color: Colors.white),
                    ),
                  ),
                ),
              ],
            ),
          )
        ],
      ),
    );
  }

  ListView buildListView(List department) {
    return ListView.builder(
        shrinkWrap: true,
        itemBuilder: (BuildContext context, int index) {
          return InkWell(
            onTap: () {
              setState(() {
                widget.chooseDepartment = department[index];
              });
            },
            child: department[index]['children'] != null && department[index]['children'].length > 0
                ? Row(
                    children: [
                      Checkbox(
                          activeColor: Theme.of(context).primaryColor,
                          value: department[index][_idKey] == widget.chooseDepartment[_idKey],
                          onChanged: (value) {
                            setState(() {
                              widget.chooseDepartment = department[index];
                            });
                          }),
                      Expanded(
                        child: CollapseCard(
                          defaultExpanded: false,
                          title: Text(
                            department[index][_nameKey] ?? '',
                            style: const TextStyle(fontSize: CoreStyles.textSizeSmall),
                          ),
                          children: [buildListView(department[index]['children'])],
                        ),
                      ),
                    ],
                  )
                : Row(
                    children: [
                      Checkbox(
                          activeColor: Theme.of(context).primaryColor,
                          value: department[index][_idKey] == widget.chooseDepartment[_idKey],
                          onChanged: (value) {
                            setState(() {
                              widget.chooseDepartment = department[index];
                            });
                          }),
                      Expanded(
                          child: ListTile(
                              title: Text(
                        department[index][_nameKey] ?? '',
                        style: const TextStyle(fontSize: CoreStyles.textSizeSmall),
                      ))),
                    ],
                  ),
          );
        },
        itemCount: department.length);
  }

  ///获取数据
  Future<void> getData();

  ///id
  String getIdKey();

  ///name
  String getNameKey();
}
