import 'package:flutter/material.dart';
import 'package:amos_iot_login_tpl/mine/offline/GetConfig.dart';

class LeadingButton extends StatelessWidget {
  final Function onWillPop;
  final bool onWillScope;
  final String theme;

  const LeadingButton({
    this.theme,
    this.onWillPop,
    this.onWillScope = false,
  });

  @override
  Widget build(BuildContext context) {
    return IconButton(
      icon: Icon(Icons.keyboard_arrow_left, color: GetConfig.getColor(this.theme), size: 32),
      onPressed: () {
        if (onWillScope) {
          if (onWillPop != null) {
            onWillPop();
          }
        } else {
          Navigator.of(context).pop();
        }
      },
    );
  }
}
