class FacilityFilter {
  String warehouseStructureName;
  String status;
  String fireFightingSystem;
  String fireEquipmentName;
  String fireEquipmentCode;
  String url;
  String eqimg;
  String fireFacilityCode;

  FacilityFilter();

  FacilityFilter.fromParams(
      {this.warehouseStructureName,
        this.status,
        this.fireFightingSystem,
        this.fireFacilityCode,
        this.fireEquipmentName,
        this.fireEquipmentCode});

  FacilityFilter.fromJson(jsonRes) {
    warehouseStructureName = jsonRes['warehouseStructureName'];
    status = jsonRes['status'] == 1 ? '异常' : '正常';
    fireFightingSystem = jsonRes['fireFightingSystem'];
    url = jsonRes['eq'];
    fireEquipmentName = jsonRes['fireEquipmentName'];
    fireEquipmentCode = jsonRes['fireEquipmentCode'];
    fireFacilityCode = jsonRes['fireFacilityCode'];
    eqimg=jsonRes['eqimg'];
  }

  FacilityFilter.fromJson2(jsonRes) {
    warehouseStructureName = jsonRes['warehouseStructureName'];
    status = jsonRes['status'] == 1 ? '异常' : '正常';
    fireFightingSystem = jsonRes['fireFightingSystem'];
    url = jsonRes['eq'];
    fireEquipmentName = jsonRes['fireEquipmentName'];
    fireEquipmentCode = jsonRes['fireEquipmentCode'];
    fireFacilityCode = jsonRes['code'];
    eqimg=jsonRes['eqimg'];
  }

  FacilityFilter.fromJson1(jsonRes) {
    warehouseStructureName = jsonRes.warehouseStructureName;
    status = jsonRes.status;
    fireFightingSystem = jsonRes.fireFightingSystem;
    url = jsonRes.url ?? '';
    fireEquipmentName = jsonRes.fireEquipmentName;
    fireEquipmentCode = jsonRes.fireEquipmentCode;
    fireFacilityCode = jsonRes.fireFacilityCode;
    eqimg=jsonRes.eqimg;
  }

  @override
  String toString() {
    return '{"buildId": $warehouseStructureName,"status": $status,"fireFightingSystem": $fireFightingSystem,",fireEquipmentName": $fireEquipmentName,"fireEquipmentCode": $fireEquipmentCode}';
  }
}
